/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse;
import software.amazon.awssdk.services.mailmanager.model.Relay;

public class ListRelaysIterable
implements SdkIterable<ListRelaysResponse> {
    private final MailManagerClient client;
    private final ListRelaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRelaysIterable(MailManagerClient client, ListRelaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRelaysResponseFetcher();
    }

    public Iterator<ListRelaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Relay> relays() {
        Function<ListRelaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.relays() != null) {
                return response.relays().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRelaysResponseFetcher
    implements SyncPageFetcher<ListRelaysResponse> {
        private ListRelaysResponseFetcher() {
        }

        public boolean hasNextPage(ListRelaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRelaysResponse nextPage(ListRelaysResponse previousPage) {
            if (previousPage == null) {
                return ListRelaysIterable.this.client.listRelays(ListRelaysIterable.this.firstRequest);
            }
            return ListRelaysIterable.this.client.listRelays((ListRelaysRequest)((Object)ListRelaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

