/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.SavedAddress;

public class ListMembersOfAddressListPublisher
implements SdkPublisher<ListMembersOfAddressListResponse> {
    private final MailManagerAsyncClient client;
    private final ListMembersOfAddressListRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMembersOfAddressListPublisher(MailManagerAsyncClient client, ListMembersOfAddressListRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMembersOfAddressListPublisher(MailManagerAsyncClient client, ListMembersOfAddressListRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMembersOfAddressListResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMembersOfAddressListResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SavedAddress> addresses() {
        Function<ListMembersOfAddressListResponse, Iterator> getIterator = response -> {
            if (response != null && response.addresses() != null) {
                return response.addresses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMembersOfAddressListResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMembersOfAddressListResponseFetcher
    implements AsyncPageFetcher<ListMembersOfAddressListResponse> {
        private ListMembersOfAddressListResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersOfAddressListResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMembersOfAddressListResponse> nextPage(ListMembersOfAddressListResponse previousPage) {
            if (previousPage == null) {
                return ListMembersOfAddressListPublisher.this.client.listMembersOfAddressList(ListMembersOfAddressListPublisher.this.firstRequest);
            }
            return ListMembersOfAddressListPublisher.this.client.listMembersOfAddressList((ListMembersOfAddressListRequest)((Object)ListMembersOfAddressListPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

