/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.AddonInstance;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse;

public class ListAddonInstancesPublisher
implements SdkPublisher<ListAddonInstancesResponse> {
    private final MailManagerAsyncClient client;
    private final ListAddonInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAddonInstancesPublisher(MailManagerAsyncClient client, ListAddonInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAddonInstancesPublisher(MailManagerAsyncClient client, ListAddonInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAddonInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAddonInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AddonInstance> addonInstances() {
        Function<ListAddonInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.addonInstances() != null) {
                return response.addonInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAddonInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAddonInstancesResponseFetcher
    implements AsyncPageFetcher<ListAddonInstancesResponse> {
        private ListAddonInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAddonInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAddonInstancesResponse> nextPage(ListAddonInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAddonInstancesPublisher.this.client.listAddonInstances(ListAddonInstancesPublisher.this.firstRequest);
            }
            return ListAddonInstancesPublisher.this.client.listAddonInstances((ListAddonInstancesRequest)((Object)ListAddonInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

