/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleStringOperator {
    EQUALS("EQUALS"),
    NOT_EQUALS("NOT_EQUALS"),
    STARTS_WITH("STARTS_WITH"),
    ENDS_WITH("ENDS_WITH"),
    CONTAINS("CONTAINS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleStringOperator> VALUE_MAP;
    private final String value;

    private RuleStringOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleStringOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleStringOperator> knownValues() {
        EnumSet<RuleStringOperator> knownValues = EnumSet.allOf(RuleStringOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleStringOperator.class, RuleStringOperator::toString);
    }
}

