/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.AddressList;
import software.amazon.awssdk.services.mailmanager.model.AddressListsCopier;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAddressListsResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListAddressListsResponse> {
    private static final SdkField<List<AddressList>> ADDRESS_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressLists").getter(ListAddressListsResponse.getter(ListAddressListsResponse::addressLists)).setter(ListAddressListsResponse.setter(Builder::addressLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddressList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAddressListsResponse.getter(ListAddressListsResponse::nextToken)).setter(ListAddressListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LISTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAddressListsResponse.memberNameToFieldInitializer();
    private final List<AddressList> addressLists;
    private final String nextToken;

    private ListAddressListsResponse(BuilderImpl builder) {
        super(builder);
        this.addressLists = builder.addressLists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAddressLists() {
        return this.addressLists != null && !(this.addressLists instanceof SdkAutoConstructList);
    }

    public final List<AddressList> addressLists() {
        return this.addressLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressLists() ? this.addressLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAddressListsResponse)) {
            return false;
        }
        ListAddressListsResponse other = (ListAddressListsResponse)((Object)obj);
        return this.hasAddressLists() == other.hasAddressLists() && Objects.equals(this.addressLists(), other.addressLists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAddressListsResponse").add("AddressLists", this.hasAddressLists() ? this.addressLists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressLists": {
                return Optional.ofNullable(clazz.cast(this.addressLists()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddressLists", ADDRESS_LISTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAddressListsResponse, T> g) {
        return obj -> g.apply((ListAddressListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private List<AddressList> addressLists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAddressListsResponse model) {
            super(model);
            this.addressLists(model.addressLists);
            this.nextToken(model.nextToken);
        }

        public final List<AddressList.Builder> getAddressLists() {
            List<AddressList.Builder> result = AddressListsCopier.copyToBuilder(this.addressLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressLists(Collection<AddressList.BuilderImpl> addressLists) {
            this.addressLists = AddressListsCopier.copyFromBuilder(addressLists);
        }

        @Override
        public final Builder addressLists(Collection<AddressList> addressLists) {
            this.addressLists = AddressListsCopier.copy(addressLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(AddressList ... addressLists) {
            this.addressLists(Arrays.asList(addressLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(Consumer<AddressList.Builder> ... addressLists) {
            this.addressLists(Stream.of(addressLists).map(c -> (AddressList)((AddressList.Builder)AddressList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAddressListsResponse build() {
            return new ListAddressListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAddressListsResponse> {
        public Builder addressLists(Collection<AddressList> var1);

        public Builder addressLists(AddressList ... var1);

        public Builder addressLists(Consumer<AddressList.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

