/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.RuleSet;
import software.amazon.awssdk.services.mailmanager.model.RuleSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleSetsResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListRuleSetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRuleSetsResponse.getter(ListRuleSetsResponse::nextToken)).setter(ListRuleSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RuleSet>> RULE_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleSets").getter(ListRuleSetsResponse.getter(ListRuleSetsResponse::ruleSets)).setter(ListRuleSetsResponse.setter(Builder::ruleSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RULE_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRuleSetsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RuleSet> ruleSets;

    private ListRuleSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ruleSets = builder.ruleSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRuleSets() {
        return this.ruleSets != null && !(this.ruleSets instanceof SdkAutoConstructList);
    }

    public final List<RuleSet> ruleSets() {
        return this.ruleSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSets() ? this.ruleSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleSetsResponse)) {
            return false;
        }
        ListRuleSetsResponse other = (ListRuleSetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRuleSets() == other.hasRuleSets() && Objects.equals(this.ruleSets(), other.ruleSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListRuleSetsResponse").add("NextToken", (Object)this.nextToken()).add("RuleSets", this.hasRuleSets() ? this.ruleSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RuleSets": {
                return Optional.ofNullable(clazz.cast(this.ruleSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RuleSets", RULE_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRuleSetsResponse, T> g) {
        return obj -> g.apply((ListRuleSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RuleSet> ruleSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleSetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ruleSets(model.ruleSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RuleSet.Builder> getRuleSets() {
            List<RuleSet.Builder> result = RuleSetsCopier.copyToBuilder(this.ruleSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSets(Collection<RuleSet.BuilderImpl> ruleSets) {
            this.ruleSets = RuleSetsCopier.copyFromBuilder(ruleSets);
        }

        @Override
        public final Builder ruleSets(Collection<RuleSet> ruleSets) {
            this.ruleSets = RuleSetsCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(RuleSet ... ruleSets) {
            this.ruleSets(Arrays.asList(ruleSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(Consumer<RuleSet.Builder> ... ruleSets) {
            this.ruleSets(Stream.of(ruleSets).map(c -> (RuleSet)((RuleSet.Builder)RuleSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRuleSetsResponse build() {
            return new ListRuleSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRuleSetsResponse> {
        public Builder nextToken(String var1);

        public Builder ruleSets(Collection<RuleSet> var1);

        public Builder ruleSets(RuleSet ... var1);

        public Builder ruleSets(Consumer<RuleSet.Builder> ... var1);
    }
}

