/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IngressPointType {
    OPEN("OPEN"),
    AUTH("AUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IngressPointType> VALUE_MAP;
    private final String value;

    private IngressPointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IngressPointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IngressPointType> knownValues() {
        EnumSet<IngressPointType> knownValues = EnumSet.allOf(IngressPointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IngressPointType.class, IngressPointType::toString);
    }
}

