/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse;
import software.amazon.awssdk.services.mailmanager.model.RuleSet;

public class ListRuleSetsIterable
implements SdkIterable<ListRuleSetsResponse> {
    private final MailManagerClient client;
    private final ListRuleSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRuleSetsIterable(MailManagerClient client, ListRuleSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRuleSetsResponseFetcher();
    }

    public Iterator<ListRuleSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleSet> ruleSets() {
        Function<ListRuleSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleSets() != null) {
                return response.ruleSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRuleSetsResponseFetcher
    implements SyncPageFetcher<ListRuleSetsResponse> {
        private ListRuleSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRuleSetsResponse nextPage(ListRuleSetsResponse previousPage) {
            if (previousPage == null) {
                return ListRuleSetsIterable.this.client.listRuleSets(ListRuleSetsIterable.this.firstRequest);
            }
            return ListRuleSetsIterable.this.client.listRuleSets((ListRuleSetsRequest)((Object)ListRuleSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

