/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.Envelope;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.Metadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetArchiveMessageResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetArchiveMessageResponse> {
    private static final SdkField<Envelope> ENVELOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Envelope").getter(GetArchiveMessageResponse.getter(GetArchiveMessageResponse::envelope)).setter(GetArchiveMessageResponse.setter(Builder::envelope)).constructor(Envelope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Envelope").build()}).build();
    private static final SdkField<String> MESSAGE_DOWNLOAD_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageDownloadLink").getter(GetArchiveMessageResponse.getter(GetArchiveMessageResponse::messageDownloadLink)).setter(GetArchiveMessageResponse.setter(Builder::messageDownloadLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDownloadLink").build()}).build();
    private static final SdkField<Metadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(GetArchiveMessageResponse.getter(GetArchiveMessageResponse::metadata)).setter(GetArchiveMessageResponse.setter(Builder::metadata)).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVELOPE_FIELD, MESSAGE_DOWNLOAD_LINK_FIELD, METADATA_FIELD));
    private final Envelope envelope;
    private final String messageDownloadLink;
    private final Metadata metadata;

    private GetArchiveMessageResponse(BuilderImpl builder) {
        super(builder);
        this.envelope = builder.envelope;
        this.messageDownloadLink = builder.messageDownloadLink;
        this.metadata = builder.metadata;
    }

    public final Envelope envelope() {
        return this.envelope;
    }

    public final String messageDownloadLink() {
        return this.messageDownloadLink;
    }

    public final Metadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.envelope());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDownloadLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveMessageResponse)) {
            return false;
        }
        GetArchiveMessageResponse other = (GetArchiveMessageResponse)((Object)obj);
        return Objects.equals(this.envelope(), other.envelope()) && Objects.equals(this.messageDownloadLink(), other.messageDownloadLink()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetArchiveMessageResponse").add("Envelope", (Object)this.envelope()).add("MessageDownloadLink", (Object)this.messageDownloadLink()).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Envelope": {
                return Optional.ofNullable(clazz.cast(this.envelope()));
            }
            case "MessageDownloadLink": {
                return Optional.ofNullable(clazz.cast(this.messageDownloadLink()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveMessageResponse, T> g) {
        return obj -> g.apply((GetArchiveMessageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private Envelope envelope;
        private String messageDownloadLink;
        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveMessageResponse model) {
            super(model);
            this.envelope(model.envelope);
            this.messageDownloadLink(model.messageDownloadLink);
            this.metadata(model.metadata);
        }

        public final Envelope.Builder getEnvelope() {
            return this.envelope != null ? this.envelope.toBuilder() : null;
        }

        public final void setEnvelope(Envelope.BuilderImpl envelope) {
            this.envelope = envelope != null ? envelope.build() : null;
        }

        @Override
        public final Builder envelope(Envelope envelope) {
            this.envelope = envelope;
            return this;
        }

        public final String getMessageDownloadLink() {
            return this.messageDownloadLink;
        }

        public final void setMessageDownloadLink(String messageDownloadLink) {
            this.messageDownloadLink = messageDownloadLink;
        }

        @Override
        public final Builder messageDownloadLink(String messageDownloadLink) {
            this.messageDownloadLink = messageDownloadLink;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetArchiveMessageResponse build() {
            return new GetArchiveMessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetArchiveMessageResponse> {
        public Builder envelope(Envelope var1);

        default public Builder envelope(Consumer<Envelope.Builder> envelope) {
            return this.envelope((Envelope)((Envelope.Builder)Envelope.builder().applyMutation(envelope)).build());
        }

        public Builder messageDownloadLink(String var1);

        public Builder metadata(Metadata var1);

        default public Builder metadata(Consumer<Metadata.Builder> metadata) {
            return this.metadata((Metadata)((Metadata.Builder)Metadata.builder().applyMutation(metadata)).build());
        }
    }
}

