/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.RelayAuthentication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelayResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetRelayResponse> {
    private static final SdkField<RelayAuthentication> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authentication").getter(GetRelayResponse.getter(GetRelayResponse::authentication)).setter(GetRelayResponse.setter(Builder::authentication)).constructor(RelayAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetRelayResponse.getter(GetRelayResponse::createdTimestamp)).setter(GetRelayResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimestamp").getter(GetRelayResponse.getter(GetRelayResponse::lastModifiedTimestamp)).setter(GetRelayResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build()}).build();
    private static final SdkField<String> RELAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayArn").getter(GetRelayResponse.getter(GetRelayResponse::relayArn)).setter(GetRelayResponse.setter(Builder::relayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayArn").build()}).build();
    private static final SdkField<String> RELAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayId").getter(GetRelayResponse.getter(GetRelayResponse::relayId)).setter(GetRelayResponse.setter(Builder::relayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayId").build()}).build();
    private static final SdkField<String> RELAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayName").getter(GetRelayResponse.getter(GetRelayResponse::relayName)).setter(GetRelayResponse.setter(Builder::relayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayName").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(GetRelayResponse.getter(GetRelayResponse::serverName)).setter(GetRelayResponse.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServerPort").getter(GetRelayResponse.getter(GetRelayResponse::serverPort)).setter(GetRelayResponse.setter(Builder::serverPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, RELAY_ARN_FIELD, RELAY_ID_FIELD, RELAY_NAME_FIELD, SERVER_NAME_FIELD, SERVER_PORT_FIELD));
    private final RelayAuthentication authentication;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String relayArn;
    private final String relayId;
    private final String relayName;
    private final String serverName;
    private final Integer serverPort;

    private GetRelayResponse(BuilderImpl builder) {
        super(builder);
        this.authentication = builder.authentication;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.relayArn = builder.relayArn;
        this.relayId = builder.relayId;
        this.relayName = builder.relayName;
        this.serverName = builder.serverName;
        this.serverPort = builder.serverPort;
    }

    public final RelayAuthentication authentication() {
        return this.authentication;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final String relayArn() {
        return this.relayArn;
    }

    public final String relayId() {
        return this.relayId;
    }

    public final String relayName() {
        return this.relayName;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer serverPort() {
        return this.serverPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelayResponse)) {
            return false;
        }
        GetRelayResponse other = (GetRelayResponse)((Object)obj);
        return Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.relayArn(), other.relayArn()) && Objects.equals(this.relayId(), other.relayId()) && Objects.equals(this.relayName(), other.relayName()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serverPort(), other.serverPort());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelayResponse").add("Authentication", (Object)this.authentication()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("RelayArn", (Object)this.relayArn()).add("RelayId", (Object)this.relayId()).add("RelayName", (Object)this.relayName()).add("ServerName", (Object)this.serverName()).add("ServerPort", (Object)this.serverPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "RelayArn": {
                return Optional.ofNullable(clazz.cast(this.relayArn()));
            }
            case "RelayId": {
                return Optional.ofNullable(clazz.cast(this.relayId()));
            }
            case "RelayName": {
                return Optional.ofNullable(clazz.cast(this.relayName()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServerPort": {
                return Optional.ofNullable(clazz.cast(this.serverPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelayResponse, T> g) {
        return obj -> g.apply((GetRelayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private RelayAuthentication authentication;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;
        private String relayArn;
        private String relayId;
        private String relayName;
        private String serverName;
        private Integer serverPort;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelayResponse model) {
            super(model);
            this.authentication(model.authentication);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.relayArn(model.relayArn);
            this.relayId(model.relayId);
            this.relayName(model.relayName);
            this.serverName(model.serverName);
            this.serverPort(model.serverPort);
        }

        public final RelayAuthentication.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(RelayAuthentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(RelayAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getRelayArn() {
            return this.relayArn;
        }

        public final void setRelayArn(String relayArn) {
            this.relayArn = relayArn;
        }

        @Override
        public final Builder relayArn(String relayArn) {
            this.relayArn = relayArn;
            return this;
        }

        public final String getRelayId() {
            return this.relayId;
        }

        public final void setRelayId(String relayId) {
            this.relayId = relayId;
        }

        @Override
        public final Builder relayId(String relayId) {
            this.relayId = relayId;
            return this;
        }

        public final String getRelayName() {
            return this.relayName;
        }

        public final void setRelayName(String relayName) {
            this.relayName = relayName;
        }

        @Override
        public final Builder relayName(String relayName) {
            this.relayName = relayName;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getServerPort() {
            return this.serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public GetRelayResponse build() {
            return new GetRelayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelayResponse> {
        public Builder authentication(RelayAuthentication var1);

        default public Builder authentication(Consumer<RelayAuthentication.Builder> authentication) {
            return this.authentication((RelayAuthentication)((RelayAuthentication.Builder)RelayAuthentication.builder().applyMutation(authentication)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder relayArn(String var1);

        public Builder relayId(String var1);

        public Builder relayName(String var1);

        public Builder serverName(String var1);

        public Builder serverPort(Integer var1);
    }
}

