/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ActionFailurePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionFailurePolicy").getter(ArchiveAction.getter(ArchiveAction::actionFailurePolicyAsString)).setter(ArchiveAction.setter(Builder::actionFailurePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build()}).build();
    private static final SdkField<String> TARGET_ARCHIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArchive").getter(ArchiveAction.getter(ArchiveAction::targetArchive)).setter(ArchiveAction.setter(Builder::targetArchive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArchive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD, TARGET_ARCHIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
            this.put("TargetArchive", TARGET_ARCHIVE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionFailurePolicy;
    private final String targetArchive;

    private ArchiveAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.targetArchive = builder.targetArchive;
    }

    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(this.actionFailurePolicy);
    }

    public final String actionFailurePolicyAsString() {
        return this.actionFailurePolicy;
    }

    public final String targetArchive() {
        return this.targetArchive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArchive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveAction)) {
            return false;
        }
        ArchiveAction other = (ArchiveAction)obj;
        return Objects.equals(this.actionFailurePolicyAsString(), other.actionFailurePolicyAsString()) && Objects.equals(this.targetArchive(), other.targetArchive());
    }

    public final String toString() {
        return ToString.builder((String)"ArchiveAction").add("ActionFailurePolicy", (Object)this.actionFailurePolicyAsString()).add("TargetArchive", (Object)this.targetArchive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionFailurePolicy": {
                return Optional.ofNullable(clazz.cast(this.actionFailurePolicyAsString()));
            }
            case "TargetArchive": {
                return Optional.ofNullable(clazz.cast(this.targetArchive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveAction, T> g) {
        return obj -> g.apply((ArchiveAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionFailurePolicy;
        private String targetArchive;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveAction model) {
            this.actionFailurePolicy(model.actionFailurePolicy);
            this.targetArchive(model.targetArchive);
        }

        public final String getActionFailurePolicy() {
            return this.actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getTargetArchive() {
            return this.targetArchive;
        }

        public final void setTargetArchive(String targetArchive) {
            this.targetArchive = targetArchive;
        }

        @Override
        public final Builder targetArchive(String targetArchive) {
            this.targetArchive = targetArchive;
            return this;
        }

        public ArchiveAction build() {
            return new ArchiveAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveAction> {
        public Builder actionFailurePolicy(String var1);

        public Builder actionFailurePolicy(ActionFailurePolicy var1);

        public Builder targetArchive(String var1);
    }
}

