/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.IngressTlsProtocolAttribute;
import software.amazon.awssdk.services.mailmanager.model.IngressTlsProtocolOperator;
import software.amazon.awssdk.services.mailmanager.model.IngressTlsProtocolToEvaluate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressTlsProtocolExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressTlsProtocolExpression> {
    private static final SdkField<IngressTlsProtocolToEvaluate> EVALUATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evaluate").getter(IngressTlsProtocolExpression.getter(IngressTlsProtocolExpression::evaluate)).setter(IngressTlsProtocolExpression.setter(Builder::evaluate)).constructor(IngressTlsProtocolToEvaluate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(IngressTlsProtocolExpression.getter(IngressTlsProtocolExpression::operatorAsString)).setter(IngressTlsProtocolExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(IngressTlsProtocolExpression.getter(IngressTlsProtocolExpression::valueAsString)).setter(IngressTlsProtocolExpression.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD, OPERATOR_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Evaluate", EVALUATE_FIELD);
            this.put("Operator", OPERATOR_FIELD);
            this.put("Value", VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final IngressTlsProtocolToEvaluate evaluate;
    private final String operator;
    private final String value;

    private IngressTlsProtocolExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    public final IngressTlsProtocolToEvaluate evaluate() {
        return this.evaluate;
    }

    public final IngressTlsProtocolOperator operator() {
        return IngressTlsProtocolOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final IngressTlsProtocolAttribute value() {
        return IngressTlsProtocolAttribute.fromValue(this.value);
    }

    public final String valueAsString() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressTlsProtocolExpression)) {
            return false;
        }
        IngressTlsProtocolExpression other = (IngressTlsProtocolExpression)obj;
        return Objects.equals(this.evaluate(), other.evaluate()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.valueAsString(), other.valueAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IngressTlsProtocolExpression").add("Evaluate", (Object)this.evaluate()).add("Operator", (Object)this.operatorAsString()).add("Value", (Object)this.valueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluate": {
                return Optional.ofNullable(clazz.cast(this.evaluate()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.valueAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IngressTlsProtocolExpression, T> g) {
        return obj -> g.apply((IngressTlsProtocolExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IngressTlsProtocolToEvaluate evaluate;
        private String operator;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressTlsProtocolExpression model) {
            this.evaluate(model.evaluate);
            this.operator(model.operator);
            this.value(model.value);
        }

        public final IngressTlsProtocolToEvaluate.Builder getEvaluate() {
            return this.evaluate != null ? this.evaluate.toBuilder() : null;
        }

        public final void setEvaluate(IngressTlsProtocolToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(IngressTlsProtocolToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngressTlsProtocolOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(IngressTlsProtocolAttribute value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        public IngressTlsProtocolExpression build() {
            return new IngressTlsProtocolExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressTlsProtocolExpression> {
        public Builder evaluate(IngressTlsProtocolToEvaluate var1);

        default public Builder evaluate(Consumer<IngressTlsProtocolToEvaluate.Builder> evaluate) {
            return this.evaluate((IngressTlsProtocolToEvaluate)((IngressTlsProtocolToEvaluate.Builder)IngressTlsProtocolToEvaluate.builder().applyMutation(evaluate)).build());
        }

        public Builder operator(String var1);

        public Builder operator(IngressTlsProtocolOperator var1);

        public Builder value(String var1);

        public Builder value(IngressTlsProtocolAttribute var1);
    }
}

