/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ActionFailurePolicy;
import software.amazon.awssdk.services.mailmanager.model.MailFrom;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelayAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelayAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionFailurePolicy").getter(RelayAction.getter(RelayAction::actionFailurePolicyAsString)).setter(RelayAction.setter(Builder::actionFailurePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build()}).build();
    private static final SdkField<String> MAIL_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailFrom").getter(RelayAction.getter(RelayAction::mailFromAsString)).setter(RelayAction.setter(Builder::mailFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFrom").build()}).build();
    private static final SdkField<String> RELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Relay").getter(RelayAction.getter(RelayAction::relay)).setter(RelayAction.setter(Builder::relay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD, MAIL_FROM_FIELD, RELAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
            this.put("MailFrom", MAIL_FROM_FIELD);
            this.put("Relay", RELAY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionFailurePolicy;
    private final String mailFrom;
    private final String relay;

    private RelayAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.mailFrom = builder.mailFrom;
        this.relay = builder.relay;
    }

    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(this.actionFailurePolicy);
    }

    public final String actionFailurePolicyAsString() {
        return this.actionFailurePolicy;
    }

    public final MailFrom mailFrom() {
        return MailFrom.fromValue(this.mailFrom);
    }

    public final String mailFromAsString() {
        return this.mailFrom;
    }

    public final String relay() {
        return this.relay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelayAction)) {
            return false;
        }
        RelayAction other = (RelayAction)obj;
        return Objects.equals(this.actionFailurePolicyAsString(), other.actionFailurePolicyAsString()) && Objects.equals(this.mailFromAsString(), other.mailFromAsString()) && Objects.equals(this.relay(), other.relay());
    }

    public final String toString() {
        return ToString.builder((String)"RelayAction").add("ActionFailurePolicy", (Object)this.actionFailurePolicyAsString()).add("MailFrom", (Object)this.mailFromAsString()).add("Relay", (Object)this.relay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionFailurePolicy": {
                return Optional.ofNullable(clazz.cast(this.actionFailurePolicyAsString()));
            }
            case "MailFrom": {
                return Optional.ofNullable(clazz.cast(this.mailFromAsString()));
            }
            case "Relay": {
                return Optional.ofNullable(clazz.cast(this.relay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RelayAction, T> g) {
        return obj -> g.apply((RelayAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionFailurePolicy;
        private String mailFrom;
        private String relay;

        private BuilderImpl() {
        }

        private BuilderImpl(RelayAction model) {
            this.actionFailurePolicy(model.actionFailurePolicy);
            this.mailFrom(model.mailFrom);
            this.relay(model.relay);
        }

        public final String getActionFailurePolicy() {
            return this.actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getMailFrom() {
            return this.mailFrom;
        }

        public final void setMailFrom(String mailFrom) {
            this.mailFrom = mailFrom;
        }

        @Override
        public final Builder mailFrom(String mailFrom) {
            this.mailFrom = mailFrom;
            return this;
        }

        @Override
        public final Builder mailFrom(MailFrom mailFrom) {
            this.mailFrom(mailFrom == null ? null : mailFrom.toString());
            return this;
        }

        public final String getRelay() {
            return this.relay;
        }

        public final void setRelay(String relay) {
            this.relay = relay;
        }

        @Override
        public final Builder relay(String relay) {
            this.relay = relay;
            return this;
        }

        public RelayAction build() {
            return new RelayAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelayAction> {
        public Builder actionFailurePolicy(String var1);

        public Builder actionFailurePolicy(ActionFailurePolicy var1);

        public Builder mailFrom(String var1);

        public Builder mailFrom(MailFrom var1);

        public Builder relay(String var1);
    }
}

