/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.IngressPoint;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse;

public class ListIngressPointsPublisher
implements SdkPublisher<ListIngressPointsResponse> {
    private final MailManagerAsyncClient client;
    private final ListIngressPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIngressPointsPublisher(MailManagerAsyncClient client, ListIngressPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIngressPointsPublisher(MailManagerAsyncClient client, ListIngressPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIngressPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIngressPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IngressPoint> ingressPoints() {
        Function<ListIngressPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingressPoints() != null) {
                return response.ingressPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIngressPointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIngressPointsResponseFetcher
    implements AsyncPageFetcher<ListIngressPointsResponse> {
        private ListIngressPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngressPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIngressPointsResponse> nextPage(ListIngressPointsResponse previousPage) {
            if (previousPage == null) {
                return ListIngressPointsPublisher.this.client.listIngressPoints(ListIngressPointsPublisher.this.firstRequest);
            }
            return ListIngressPointsPublisher.this.client.listIngressPoints((ListIngressPointsRequest)((Object)ListIngressPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

