/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.RuleNumberOperator;
import software.amazon.awssdk.services.mailmanager.model.RuleNumberToEvaluate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleNumberExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleNumberExpression> {
    private static final SdkField<RuleNumberToEvaluate> EVALUATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evaluate").getter(RuleNumberExpression.getter(RuleNumberExpression::evaluate)).setter(RuleNumberExpression.setter(Builder::evaluate)).constructor(RuleNumberToEvaluate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(RuleNumberExpression.getter(RuleNumberExpression::operatorAsString)).setter(RuleNumberExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(RuleNumberExpression.getter(RuleNumberExpression::value)).setter(RuleNumberExpression.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD, OPERATOR_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final RuleNumberToEvaluate evaluate;
    private final String operator;
    private final Double value;

    private RuleNumberExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    public final RuleNumberToEvaluate evaluate() {
        return this.evaluate;
    }

    public final RuleNumberOperator operator() {
        return RuleNumberOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final Double value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleNumberExpression)) {
            return false;
        }
        RuleNumberExpression other = (RuleNumberExpression)obj;
        return Objects.equals(this.evaluate(), other.evaluate()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"RuleNumberExpression").add("Evaluate", (Object)this.evaluate()).add("Operator", (Object)this.operatorAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluate": {
                return Optional.ofNullable(clazz.cast(this.evaluate()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleNumberExpression, T> g) {
        return obj -> g.apply((RuleNumberExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RuleNumberToEvaluate evaluate;
        private String operator;
        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleNumberExpression model) {
            this.evaluate(model.evaluate);
            this.operator(model.operator);
            this.value(model.value);
        }

        public final RuleNumberToEvaluate.Builder getEvaluate() {
            return this.evaluate != null ? this.evaluate.toBuilder() : null;
        }

        public final void setEvaluate(RuleNumberToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(RuleNumberToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleNumberOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public RuleNumberExpression build() {
            return new RuleNumberExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleNumberExpression> {
        public Builder evaluate(RuleNumberToEvaluate var1);

        default public Builder evaluate(Consumer<RuleNumberToEvaluate.Builder> evaluate) {
            return this.evaluate((RuleNumberToEvaluate)((RuleNumberToEvaluate.Builder)RuleNumberToEvaluate.builder().applyMutation(evaluate)).build());
        }

        public Builder operator(String var1);

        public Builder operator(RuleNumberOperator var1);

        public Builder value(Double var1);
    }
}

