/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ExportSummary;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse;

public class ListArchiveExportsIterable
implements SdkIterable<ListArchiveExportsResponse> {
    private final MailManagerClient client;
    private final ListArchiveExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArchiveExportsIterable(MailManagerClient client, ListArchiveExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListArchiveExportsResponseFetcher();
    }

    public Iterator<ListArchiveExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportSummary> exports() {
        Function<ListArchiveExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exports() != null) {
                return response.exports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListArchiveExportsResponseFetcher
    implements SyncPageFetcher<ListArchiveExportsResponse> {
        private ListArchiveExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListArchiveExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListArchiveExportsResponse nextPage(ListArchiveExportsResponse previousPage) {
            if (previousPage == null) {
                return ListArchiveExportsIterable.this.client.listArchiveExports(ListArchiveExportsIterable.this.firstRequest);
            }
            return ListArchiveExportsIterable.this.client.listArchiveExports((ListArchiveExportsRequest)((Object)ListArchiveExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

