/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.IngressBooleanExpression;
import software.amazon.awssdk.services.mailmanager.model.IngressIpv4Expression;
import software.amazon.awssdk.services.mailmanager.model.IngressStringExpression;
import software.amazon.awssdk.services.mailmanager.model.IngressTlsProtocolExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyCondition> {
    private static final SdkField<IngressBooleanExpression> BOOLEAN_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BooleanExpression").getter(PolicyCondition.getter(PolicyCondition::booleanExpression)).setter(PolicyCondition.setter(Builder::booleanExpression)).constructor(IngressBooleanExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanExpression").build()}).build();
    private static final SdkField<IngressIpv4Expression> IP_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpExpression").getter(PolicyCondition.getter(PolicyCondition::ipExpression)).setter(PolicyCondition.setter(Builder::ipExpression)).constructor(IngressIpv4Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpExpression").build()}).build();
    private static final SdkField<IngressStringExpression> STRING_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringExpression").getter(PolicyCondition.getter(PolicyCondition::stringExpression)).setter(PolicyCondition.setter(Builder::stringExpression)).constructor(IngressStringExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringExpression").build()}).build();
    private static final SdkField<IngressTlsProtocolExpression> TLS_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TlsExpression").getter(PolicyCondition.getter(PolicyCondition::tlsExpression)).setter(PolicyCondition.setter(Builder::tlsExpression)).constructor(IngressTlsProtocolExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_EXPRESSION_FIELD, IP_EXPRESSION_FIELD, STRING_EXPRESSION_FIELD, TLS_EXPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final IngressBooleanExpression booleanExpression;
    private final IngressIpv4Expression ipExpression;
    private final IngressStringExpression stringExpression;
    private final IngressTlsProtocolExpression tlsExpression;
    private final Type type;

    private PolicyCondition(BuilderImpl builder) {
        this.booleanExpression = builder.booleanExpression;
        this.ipExpression = builder.ipExpression;
        this.stringExpression = builder.stringExpression;
        this.tlsExpression = builder.tlsExpression;
        this.type = builder.type;
    }

    public final IngressBooleanExpression booleanExpression() {
        return this.booleanExpression;
    }

    public final IngressIpv4Expression ipExpression() {
        return this.ipExpression;
    }

    public final IngressStringExpression stringExpression() {
        return this.stringExpression;
    }

    public final IngressTlsProtocolExpression tlsExpression() {
        return this.tlsExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyCondition)) {
            return false;
        }
        PolicyCondition other = (PolicyCondition)obj;
        return Objects.equals(this.booleanExpression(), other.booleanExpression()) && Objects.equals(this.ipExpression(), other.ipExpression()) && Objects.equals(this.stringExpression(), other.stringExpression()) && Objects.equals(this.tlsExpression(), other.tlsExpression());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyCondition").add("BooleanExpression", (Object)this.booleanExpression()).add("IpExpression", (Object)this.ipExpression()).add("StringExpression", (Object)this.stringExpression()).add("TlsExpression", (Object)this.tlsExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BooleanExpression": {
                return Optional.ofNullable(clazz.cast(this.booleanExpression()));
            }
            case "IpExpression": {
                return Optional.ofNullable(clazz.cast(this.ipExpression()));
            }
            case "StringExpression": {
                return Optional.ofNullable(clazz.cast(this.stringExpression()));
            }
            case "TlsExpression": {
                return Optional.ofNullable(clazz.cast(this.tlsExpression()));
            }
        }
        return Optional.empty();
    }

    public static PolicyCondition fromBooleanExpression(IngressBooleanExpression booleanExpression) {
        return (PolicyCondition)PolicyCondition.builder().booleanExpression(booleanExpression).build();
    }

    public static PolicyCondition fromBooleanExpression(Consumer<IngressBooleanExpression.Builder> booleanExpression) {
        IngressBooleanExpression.Builder builder = IngressBooleanExpression.builder();
        booleanExpression.accept(builder);
        return PolicyCondition.fromBooleanExpression((IngressBooleanExpression)builder.build());
    }

    public static PolicyCondition fromIpExpression(IngressIpv4Expression ipExpression) {
        return (PolicyCondition)PolicyCondition.builder().ipExpression(ipExpression).build();
    }

    public static PolicyCondition fromIpExpression(Consumer<IngressIpv4Expression.Builder> ipExpression) {
        IngressIpv4Expression.Builder builder = IngressIpv4Expression.builder();
        ipExpression.accept(builder);
        return PolicyCondition.fromIpExpression((IngressIpv4Expression)builder.build());
    }

    public static PolicyCondition fromStringExpression(IngressStringExpression stringExpression) {
        return (PolicyCondition)PolicyCondition.builder().stringExpression(stringExpression).build();
    }

    public static PolicyCondition fromStringExpression(Consumer<IngressStringExpression.Builder> stringExpression) {
        IngressStringExpression.Builder builder = IngressStringExpression.builder();
        stringExpression.accept(builder);
        return PolicyCondition.fromStringExpression((IngressStringExpression)builder.build());
    }

    public static PolicyCondition fromTlsExpression(IngressTlsProtocolExpression tlsExpression) {
        return (PolicyCondition)PolicyCondition.builder().tlsExpression(tlsExpression).build();
    }

    public static PolicyCondition fromTlsExpression(Consumer<IngressTlsProtocolExpression.Builder> tlsExpression) {
        IngressTlsProtocolExpression.Builder builder = IngressTlsProtocolExpression.builder();
        tlsExpression.accept(builder);
        return PolicyCondition.fromTlsExpression((IngressTlsProtocolExpression)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyCondition, T> g) {
        return obj -> g.apply((PolicyCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOLEAN_EXPRESSION,
        IP_EXPRESSION,
        STRING_EXPRESSION,
        TLS_EXPRESSION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IngressBooleanExpression booleanExpression;
        private IngressIpv4Expression ipExpression;
        private IngressStringExpression stringExpression;
        private IngressTlsProtocolExpression tlsExpression;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyCondition model) {
            this.booleanExpression(model.booleanExpression);
            this.ipExpression(model.ipExpression);
            this.stringExpression(model.stringExpression);
            this.tlsExpression(model.tlsExpression);
        }

        public final IngressBooleanExpression.Builder getBooleanExpression() {
            return this.booleanExpression != null ? this.booleanExpression.toBuilder() : null;
        }

        public final void setBooleanExpression(IngressBooleanExpression.BuilderImpl booleanExpression) {
            IngressBooleanExpression oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression != null ? booleanExpression.build() : null;
            this.handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
        }

        @Override
        public final Builder booleanExpression(IngressBooleanExpression booleanExpression) {
            IngressBooleanExpression oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression;
            this.handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
            return this;
        }

        public final IngressIpv4Expression.Builder getIpExpression() {
            return this.ipExpression != null ? this.ipExpression.toBuilder() : null;
        }

        public final void setIpExpression(IngressIpv4Expression.BuilderImpl ipExpression) {
            IngressIpv4Expression oldValue = this.ipExpression;
            this.ipExpression = ipExpression != null ? ipExpression.build() : null;
            this.handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
        }

        @Override
        public final Builder ipExpression(IngressIpv4Expression ipExpression) {
            IngressIpv4Expression oldValue = this.ipExpression;
            this.ipExpression = ipExpression;
            this.handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
            return this;
        }

        public final IngressStringExpression.Builder getStringExpression() {
            return this.stringExpression != null ? this.stringExpression.toBuilder() : null;
        }

        public final void setStringExpression(IngressStringExpression.BuilderImpl stringExpression) {
            IngressStringExpression oldValue = this.stringExpression;
            this.stringExpression = stringExpression != null ? stringExpression.build() : null;
            this.handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
        }

        @Override
        public final Builder stringExpression(IngressStringExpression stringExpression) {
            IngressStringExpression oldValue = this.stringExpression;
            this.stringExpression = stringExpression;
            this.handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
            return this;
        }

        public final IngressTlsProtocolExpression.Builder getTlsExpression() {
            return this.tlsExpression != null ? this.tlsExpression.toBuilder() : null;
        }

        public final void setTlsExpression(IngressTlsProtocolExpression.BuilderImpl tlsExpression) {
            IngressTlsProtocolExpression oldValue = this.tlsExpression;
            this.tlsExpression = tlsExpression != null ? tlsExpression.build() : null;
            this.handleUnionValueChange(Type.TLS_EXPRESSION, oldValue, this.tlsExpression);
        }

        @Override
        public final Builder tlsExpression(IngressTlsProtocolExpression tlsExpression) {
            IngressTlsProtocolExpression oldValue = this.tlsExpression;
            this.tlsExpression = tlsExpression;
            this.handleUnionValueChange(Type.TLS_EXPRESSION, oldValue, this.tlsExpression);
            return this;
        }

        public PolicyCondition build() {
            return new PolicyCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyCondition> {
        public Builder booleanExpression(IngressBooleanExpression var1);

        default public Builder booleanExpression(Consumer<IngressBooleanExpression.Builder> booleanExpression) {
            return this.booleanExpression((IngressBooleanExpression)((IngressBooleanExpression.Builder)IngressBooleanExpression.builder().applyMutation(booleanExpression)).build());
        }

        public Builder ipExpression(IngressIpv4Expression var1);

        default public Builder ipExpression(Consumer<IngressIpv4Expression.Builder> ipExpression) {
            return this.ipExpression((IngressIpv4Expression)((IngressIpv4Expression.Builder)IngressIpv4Expression.builder().applyMutation(ipExpression)).build());
        }

        public Builder stringExpression(IngressStringExpression var1);

        default public Builder stringExpression(Consumer<IngressStringExpression.Builder> stringExpression) {
            return this.stringExpression((IngressStringExpression)((IngressStringExpression.Builder)IngressStringExpression.builder().applyMutation(stringExpression)).build());
        }

        public Builder tlsExpression(IngressTlsProtocolExpression var1);

        default public Builder tlsExpression(Consumer<IngressTlsProtocolExpression.Builder> tlsExpression) {
            return this.tlsExpression((IngressTlsProtocolExpression)((IngressTlsProtocolExpression.Builder)IngressTlsProtocolExpression.builder().applyMutation(tlsExpression)).build());
        }
    }
}

