/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.IngressPointStatus;
import software.amazon.awssdk.services.mailmanager.model.IngressPointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressPoint> {
    private static final SdkField<String> A_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARecord").getter(IngressPoint.getter(IngressPoint::aRecord)).setter(IngressPoint.setter(Builder::aRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARecord").build()}).build();
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointId").getter(IngressPoint.getter(IngressPoint::ingressPointId)).setter(IngressPoint.setter(Builder::ingressPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()}).build();
    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointName").getter(IngressPoint.getter(IngressPoint::ingressPointName)).setter(IngressPoint.setter(Builder::ingressPointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IngressPoint.getter(IngressPoint::statusAsString)).setter(IngressPoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(IngressPoint.getter(IngressPoint::typeAsString)).setter(IngressPoint.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(A_RECORD_FIELD, INGRESS_POINT_ID_FIELD, INGRESS_POINT_NAME_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aRecord;
    private final String ingressPointId;
    private final String ingressPointName;
    private final String status;
    private final String type;

    private IngressPoint(BuilderImpl builder) {
        this.aRecord = builder.aRecord;
        this.ingressPointId = builder.ingressPointId;
        this.ingressPointName = builder.ingressPointName;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final String aRecord() {
        return this.aRecord;
    }

    public final String ingressPointId() {
        return this.ingressPointId;
    }

    public final String ingressPointName() {
        return this.ingressPointName;
    }

    public final IngressPointStatus status() {
        return IngressPointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final IngressPointType type() {
        return IngressPointType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPoint)) {
            return false;
        }
        IngressPoint other = (IngressPoint)obj;
        return Objects.equals(this.aRecord(), other.aRecord()) && Objects.equals(this.ingressPointId(), other.ingressPointId()) && Objects.equals(this.ingressPointName(), other.ingressPointName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IngressPoint").add("ARecord", (Object)this.aRecord()).add("IngressPointId", (Object)this.ingressPointId()).add("IngressPointName", (Object)this.ingressPointName()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARecord": {
                return Optional.ofNullable(clazz.cast(this.aRecord()));
            }
            case "IngressPointId": {
                return Optional.ofNullable(clazz.cast(this.ingressPointId()));
            }
            case "IngressPointName": {
                return Optional.ofNullable(clazz.cast(this.ingressPointName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngressPoint, T> g) {
        return obj -> g.apply((IngressPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aRecord;
        private String ingressPointId;
        private String ingressPointName;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPoint model) {
            this.aRecord(model.aRecord);
            this.ingressPointId(model.ingressPointId);
            this.ingressPointName(model.ingressPointName);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getARecord() {
            return this.aRecord;
        }

        public final void setARecord(String aRecord) {
            this.aRecord = aRecord;
        }

        @Override
        public final Builder aRecord(String aRecord) {
            this.aRecord = aRecord;
            return this;
        }

        public final String getIngressPointId() {
            return this.ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getIngressPointName() {
            return this.ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngressPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IngressPointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public IngressPoint build() {
            return new IngressPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressPoint> {
        public Builder aRecord(String var1);

        public Builder ingressPointId(String var1);

        public Builder ingressPointName(String var1);

        public Builder status(String var1);

        public Builder status(IngressPointStatus var1);

        public Builder type(String var1);

        public Builder type(IngressPointType var1);
    }
}

