/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageStatisticsFilterKey {
    ACCOUNT_ID("accountId"),
    SERVICE_LIMIT("serviceLimit"),
    FREE_TRIAL_START_DATE("freeTrialStartDate"),
    TOTAL("total"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageStatisticsFilterKey> VALUE_MAP;
    private final String value;

    private UsageStatisticsFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageStatisticsFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageStatisticsFilterKey> knownValues() {
        EnumSet<UsageStatisticsFilterKey> knownValues = EnumSet.allOf(UsageStatisticsFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageStatisticsFilterKey.class, UsageStatisticsFilterKey::toString);
    }
}

