/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.RevealConfiguration;
import software.amazon.awssdk.services.macie2.model.UpdateRetrievalConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRevealConfigurationRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, UpdateRevealConfigurationRequest> {
    private static final SdkField<RevealConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateRevealConfigurationRequest.getter(UpdateRevealConfigurationRequest::configuration)).setter(UpdateRevealConfigurationRequest.setter(Builder::configuration)).constructor(RevealConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<UpdateRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrievalConfiguration").getter(UpdateRevealConfigurationRequest.getter(UpdateRevealConfigurationRequest::retrievalConfiguration)).setter(UpdateRevealConfigurationRequest.setter(Builder::retrievalConfiguration)).constructor(UpdateRetrievalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, RETRIEVAL_CONFIGURATION_FIELD));
    private final RevealConfiguration configuration;
    private final UpdateRetrievalConfiguration retrievalConfiguration;

    private UpdateRevealConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.retrievalConfiguration = builder.retrievalConfiguration;
    }

    public final RevealConfiguration configuration() {
        return this.configuration;
    }

    public final UpdateRetrievalConfiguration retrievalConfiguration() {
        return this.retrievalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRevealConfigurationRequest)) {
            return false;
        }
        UpdateRevealConfigurationRequest other = (UpdateRevealConfigurationRequest)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.retrievalConfiguration(), other.retrievalConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRevealConfigurationRequest").add("Configuration", (Object)this.configuration()).add("RetrievalConfiguration", (Object)this.retrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "retrievalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrievalConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRevealConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateRevealConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private RevealConfiguration configuration;
        private UpdateRetrievalConfiguration retrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRevealConfigurationRequest model) {
            super(model);
            this.configuration(model.configuration);
            this.retrievalConfiguration(model.retrievalConfiguration);
        }

        public final RevealConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RevealConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RevealConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final UpdateRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return this.retrievalConfiguration != null ? this.retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(UpdateRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(UpdateRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRevealConfigurationRequest build() {
            return new UpdateRevealConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRevealConfigurationRequest> {
        public Builder configuration(RevealConfiguration var1);

        default public Builder configuration(Consumer<RevealConfiguration.Builder> configuration) {
            return this.configuration((RevealConfiguration)((RevealConfiguration.Builder)RevealConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder retrievalConfiguration(UpdateRetrievalConfiguration var1);

        default public Builder retrievalConfiguration(Consumer<UpdateRetrievalConfiguration.Builder> retrievalConfiguration) {
            return this.retrievalConfiguration((UpdateRetrievalConfiguration)((UpdateRetrievalConfiguration.Builder)UpdateRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

