/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DataSourcesCopier;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataSourcesResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, DescribeDataSourcesResponse> {
    private static final SdkField<List<DataSource>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(DescribeDataSourcesResponse.getter(DescribeDataSourcesResponse::results)).setter(DescribeDataSourcesResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDataSourcesResponse.getter(DescribeDataSourcesResponse::nextToken)).setter(DescribeDataSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDataSourcesResponse.memberNameToFieldInitializer();
    private final List<DataSource> results;
    private final String nextToken;

    private DescribeDataSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<DataSource> results() {
        return this.results;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourcesResponse)) {
            return false;
        }
        DescribeDataSourcesResponse other = (DescribeDataSourcesResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataSourcesResponse").add("Results", this.hasResults() ? this.results() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Results", RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSourcesResponse, T> g) {
        return obj -> g.apply((DescribeDataSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private List<DataSource> results = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSourcesResponse model) {
            super(model);
            this.results(model.results);
            this.nextToken(model.nextToken);
        }

        public final List<DataSource.Builder> getResults() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<DataSource.BuilderImpl> results) {
            this.results = DataSourcesCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<DataSource> results) {
            this.results = DataSourcesCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(DataSource ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<DataSource.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDataSourcesResponse build() {
            return new DescribeDataSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataSourcesResponse> {
        public Builder results(Collection<DataSource> var1);

        public Builder results(DataSource ... var1);

        public Builder results(Consumer<DataSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

