/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDatabase> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RedshiftDatabase.getter(RedshiftDatabase::databaseName)).setter(RedshiftDatabase.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(RedshiftDatabase.getter(RedshiftDatabase::clusterIdentifier)).setter(RedshiftDatabase.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, CLUSTER_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String clusterIdentifier;

    private RedshiftDatabase(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatabase)) {
            return false;
        }
        RedshiftDatabase other = (RedshiftDatabase)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"RedshiftDatabase").add("DatabaseName", (Object)this.databaseName()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDatabase, T> g) {
        return obj -> g.apply((RedshiftDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatabase model) {
            this.databaseName(model.databaseName);
            this.clusterIdentifier(model.clusterIdentifier);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public RedshiftDatabase build() {
            return new RedshiftDatabase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDatabase> {
        public Builder databaseName(String var1);

        public Builder clusterIdentifier(String var1);
    }
}

