/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.machinelearning.model.MLModelType;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMlModelRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateMlModelRequest> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLModelId").getter(CreateMlModelRequest.getter(CreateMlModelRequest::mlModelId)).setter(CreateMlModelRequest.setter(Builder::mlModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()}).build();
    private static final SdkField<String> ML_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLModelName").getter(CreateMlModelRequest.getter(CreateMlModelRequest::mlModelName)).setter(CreateMlModelRequest.setter(Builder::mlModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelName").build()}).build();
    private static final SdkField<String> ML_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLModelType").getter(CreateMlModelRequest.getter(CreateMlModelRequest::mlModelTypeAsString)).setter(CreateMlModelRequest.setter(Builder::mlModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelType").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(CreateMlModelRequest.getter(CreateMlModelRequest::parameters)).setter(CreateMlModelRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRAINING_DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingDataSourceId").getter(CreateMlModelRequest.getter(CreateMlModelRequest::trainingDataSourceId)).setter(CreateMlModelRequest.setter(Builder::trainingDataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataSourceId").build()}).build();
    private static final SdkField<String> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Recipe").getter(CreateMlModelRequest.getter(CreateMlModelRequest::recipe)).setter(CreateMlModelRequest.setter(Builder::recipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipe").build()}).build();
    private static final SdkField<String> RECIPE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipeUri").getter(CreateMlModelRequest.getter(CreateMlModelRequest::recipeUri)).setter(CreateMlModelRequest.setter(Builder::recipeUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD, ML_MODEL_NAME_FIELD, ML_MODEL_TYPE_FIELD, PARAMETERS_FIELD, TRAINING_DATA_SOURCE_ID_FIELD, RECIPE_FIELD, RECIPE_URI_FIELD));
    private final String mlModelId;
    private final String mlModelName;
    private final String mlModelType;
    private final Map<String, String> parameters;
    private final String trainingDataSourceId;
    private final String recipe;
    private final String recipeUri;

    private CreateMlModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.mlModelType = builder.mlModelType;
        this.parameters = builder.parameters;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.recipe = builder.recipe;
        this.recipeUri = builder.recipeUri;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String mlModelName() {
        return this.mlModelName;
    }

    public MLModelType mlModelType() {
        return MLModelType.fromValue(this.mlModelType);
    }

    public String mlModelTypeAsString() {
        return this.mlModelType;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String trainingDataSourceId() {
        return this.trainingDataSourceId;
    }

    public String recipe() {
        return this.recipe;
    }

    public String recipeUri() {
        return this.recipeUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlModelRequest)) {
            return false;
        }
        CreateMlModelRequest other = (CreateMlModelRequest)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.mlModelName(), other.mlModelName()) && Objects.equals(this.mlModelTypeAsString(), other.mlModelTypeAsString()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.trainingDataSourceId(), other.trainingDataSourceId()) && Objects.equals(this.recipe(), other.recipe()) && Objects.equals(this.recipeUri(), other.recipeUri());
    }

    public String toString() {
        return ToString.builder((String)"CreateMlModelRequest").add("MLModelId", (Object)this.mlModelId()).add("MLModelName", (Object)this.mlModelName()).add("MLModelType", (Object)this.mlModelTypeAsString()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("TrainingDataSourceId", (Object)this.trainingDataSourceId()).add("Recipe", (Object)this.recipe()).add("RecipeUri", (Object)this.recipeUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.ofNullable(clazz.cast(this.mlModelId()));
            }
            case "MLModelName": {
                return Optional.ofNullable(clazz.cast(this.mlModelName()));
            }
            case "MLModelType": {
                return Optional.ofNullable(clazz.cast(this.mlModelTypeAsString()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "TrainingDataSourceId": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSourceId()));
            }
            case "Recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
            case "RecipeUri": {
                return Optional.ofNullable(clazz.cast(this.recipeUri()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMlModelRequest, T> g) {
        return obj -> g.apply((CreateMlModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String mlModelId;
        private String mlModelName;
        private String mlModelType;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String trainingDataSourceId;
        private String recipe;
        private String recipeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlModelRequest model) {
            super(model);
            this.mlModelId(model.mlModelId);
            this.mlModelName(model.mlModelName);
            this.mlModelType(model.mlModelType);
            this.parameters(model.parameters);
            this.trainingDataSourceId(model.trainingDataSourceId);
            this.recipe(model.recipe);
            this.recipeUri(model.recipeUri);
        }

        public final String getMlModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMlModelName() {
            return this.mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final String getMlModelType() {
            return this.mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType == null ? null : mlModelType.toString());
            return this;
        }

        public final void setMlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
        }

        public final String getTrainingDataSourceId() {
            return this.trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getRecipe() {
            return this.recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getRecipeUri() {
            return this.recipeUri;
        }

        @Override
        public final Builder recipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
            return this;
        }

        public final void setRecipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlModelRequest build() {
            return new CreateMlModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMlModelRequest> {
        public Builder mlModelId(String var1);

        public Builder mlModelName(String var1);

        public Builder mlModelType(String var1);

        public Builder mlModelType(MLModelType var1);

        public Builder parameters(Map<String, String> var1);

        public Builder trainingDataSourceId(String var1);

        public Builder recipe(String var1);

        public Builder recipeUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

