/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;

public class DescribeDataSourcesIterable
implements SdkIterable<DescribeDataSourcesResponse> {
    private final MachineLearningClient client;
    private final DescribeDataSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataSourcesIterable(MachineLearningClient client, DescribeDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataSourcesResponseFetcher();
    }

    public Iterator<DescribeDataSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSource> results() {
        Function<DescribeDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDataSourcesIterable resume(DescribeDataSourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDataSourcesIterable(this.client, (DescribeDataSourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeDataSourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDataSourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDataSourcesResponseFetcher
    implements SyncPageFetcher<DescribeDataSourcesResponse> {
        private DescribeDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDataSourcesResponse nextPage(DescribeDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSourcesIterable.this.client.describeDataSources(DescribeDataSourcesIterable.this.firstRequest);
            }
            return DescribeDataSourcesIterable.this.client.describeDataSources((DescribeDataSourcesRequest)((Object)DescribeDataSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

