/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRealtimeEndpointResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, CreateRealtimeEndpointResponse> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRealtimeEndpointResponse.getter(CreateRealtimeEndpointResponse::mlModelId)).setter(CreateRealtimeEndpointResponse.setter(Builder::mlModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()}).build();
    private static final SdkField<RealtimeEndpointInfo> REALTIME_ENDPOINT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateRealtimeEndpointResponse.getter(CreateRealtimeEndpointResponse::realtimeEndpointInfo)).setter(CreateRealtimeEndpointResponse.setter(Builder::realtimeEndpointInfo)).constructor(RealtimeEndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeEndpointInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD, REALTIME_ENDPOINT_INFO_FIELD));
    private final String mlModelId;
    private final RealtimeEndpointInfo realtimeEndpointInfo;

    private CreateRealtimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.realtimeEndpointInfo = builder.realtimeEndpointInfo;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public RealtimeEndpointInfo realtimeEndpointInfo() {
        return this.realtimeEndpointInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.realtimeEndpointInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRealtimeEndpointResponse)) {
            return false;
        }
        CreateRealtimeEndpointResponse other = (CreateRealtimeEndpointResponse)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.realtimeEndpointInfo(), other.realtimeEndpointInfo());
    }

    public String toString() {
        return ToString.builder((String)"CreateRealtimeEndpointResponse").add("MLModelId", (Object)this.mlModelId()).add("RealtimeEndpointInfo", (Object)this.realtimeEndpointInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.ofNullable(clazz.cast(this.mlModelId()));
            }
            case "RealtimeEndpointInfo": {
                return Optional.ofNullable(clazz.cast(this.realtimeEndpointInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRealtimeEndpointResponse, T> g) {
        return obj -> g.apply((CreateRealtimeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String mlModelId;
        private RealtimeEndpointInfo realtimeEndpointInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRealtimeEndpointResponse model) {
            super(model);
            this.mlModelId(model.mlModelId);
            this.realtimeEndpointInfo(model.realtimeEndpointInfo);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final RealtimeEndpointInfo.Builder getRealtimeEndpointInfo() {
            return this.realtimeEndpointInfo != null ? this.realtimeEndpointInfo.toBuilder() : null;
        }

        @Override
        public final Builder realtimeEndpointInfo(RealtimeEndpointInfo realtimeEndpointInfo) {
            this.realtimeEndpointInfo = realtimeEndpointInfo;
            return this;
        }

        public final void setRealtimeEndpointInfo(RealtimeEndpointInfo.BuilderImpl realtimeEndpointInfo) {
            this.realtimeEndpointInfo = realtimeEndpointInfo != null ? realtimeEndpointInfo.build() : null;
        }

        @Override
        public CreateRealtimeEndpointResponse build() {
            return new CreateRealtimeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRealtimeEndpointResponse> {
        public Builder mlModelId(String var1);

        public Builder realtimeEndpointInfo(RealtimeEndpointInfo var1);

        default public Builder realtimeEndpointInfo(Consumer<RealtimeEndpointInfo.Builder> realtimeEndpointInfo) {
            return this.realtimeEndpointInfo((RealtimeEndpointInfo)((RealtimeEndpointInfo.Builder)RealtimeEndpointInfo.builder().applyMutation(realtimeEndpointInfo)).build());
        }
    }
}

