/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.machinelearning.model.Evaluation;
import software.amazon.awssdk.services.machinelearning.model.EvaluationsCopier;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEvaluationsResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, DescribeEvaluationsResponse> {
    private final List<Evaluation> results;
    private final String nextToken;

    private DescribeEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    public List<Evaluation> results() {
        return this.results;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEvaluationsResponse)) {
            return false;
        }
        DescribeEvaluationsResponse other = (DescribeEvaluationsResponse)((Object)obj);
        return Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEvaluationsResponse").add("Results", this.results()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.of(clazz.cast(this.results()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private List<Evaluation> results;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEvaluationsResponse model) {
            this.results(model.results);
            this.nextToken(model.nextToken);
        }

        public final Collection<Evaluation.Builder> getResults() {
            return this.results != null ? (Collection)this.results.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<Evaluation> results) {
            this.results = EvaluationsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Evaluation ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<Evaluation.BuilderImpl> results) {
            this.results = EvaluationsCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEvaluationsResponse build() {
            return new DescribeEvaluationsResponse(this);
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    CopyableBuilder<Builder, DescribeEvaluationsResponse> {
        public Builder results(Collection<Evaluation> var1);

        public Builder results(Evaluation ... var1);

        public Builder nextToken(String var1);
    }
}

