/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEvaluationRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateEvaluationRequest> {
    private final String evaluationId;
    private final String evaluationName;
    private final String mlModelId;
    private final String evaluationDataSourceId;

    private CreateEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.evaluationName = builder.evaluationName;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
    }

    public String evaluationId() {
        return this.evaluationId;
    }

    public String evaluationName() {
        return this.evaluationName;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String evaluationDataSourceId() {
        return this.evaluationDataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataSourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationRequest)) {
            return false;
        }
        CreateEvaluationRequest other = (CreateEvaluationRequest)((Object)obj);
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationName(), other.evaluationName()) && Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.evaluationDataSourceId(), other.evaluationDataSourceId());
    }

    public String toString() {
        return ToString.builder((String)"CreateEvaluationRequest").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationName", (Object)this.evaluationName()).add("MLModelId", (Object)this.mlModelId()).add("EvaluationDataSourceId", (Object)this.evaluationDataSourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.of(clazz.cast(this.evaluationId()));
            }
            case "EvaluationName": {
                return Optional.of(clazz.cast(this.evaluationName()));
            }
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "EvaluationDataSourceId": {
                return Optional.of(clazz.cast(this.evaluationDataSourceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationName;
        private String mlModelId;
        private String evaluationDataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationRequest model) {
            this.evaluationId(model.evaluationId);
            this.evaluationName(model.evaluationName);
            this.mlModelId(model.mlModelId);
            this.evaluationDataSourceId(model.evaluationDataSourceId);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getEvaluationName() {
            return this.evaluationName;
        }

        @Override
        public final Builder evaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
            return this;
        }

        public final void setEvaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getEvaluationDataSourceId() {
            return this.evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateEvaluationRequest build() {
            return new CreateEvaluationRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, CreateEvaluationRequest> {
        public Builder evaluationId(String var1);

        public Builder evaluationName(String var1);

        public Builder mlModelId(String var1);

        public Builder evaluationDataSourceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

