/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;

public class RDSDatabaseUnmarshaller
implements Unmarshaller<RDSDatabase, JsonUnmarshallerContext> {
    private static final RDSDatabaseUnmarshaller INSTANCE = new RDSDatabaseUnmarshaller();

    public RDSDatabase unmarshall(JsonUnmarshallerContext context) throws Exception {
        RDSDatabase.Builder rdsDatabaseBuilder = RDSDatabase.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InstanceIdentifier", targetDepth)) {
                    context.nextToken();
                    rdsDatabaseBuilder.instanceIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    rdsDatabaseBuilder.databaseName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RDSDatabase)rdsDatabaseBuilder.build();
    }

    public static RDSDatabaseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

