/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDataSourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetDataSourceRequest> {
    private final String dataSourceId;
    private final Boolean verbose;

    private GetDataSourceRequest(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.verbose = builder.verbose;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public Boolean verbose() {
        return this.verbose;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataSourceId() == null ? 0 : this.dataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.verbose() == null ? 0 : this.verbose().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceRequest)) {
            return false;
        }
        GetDataSourceRequest other = (GetDataSourceRequest)((Object)obj);
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.verbose() == null ^ this.verbose() == null) {
            return false;
        }
        return other.verbose() == null || other.verbose().equals(this.verbose());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (this.verbose() != null) {
            sb.append("Verbose: ").append(this.verbose()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "Verbose": {
                return Optional.of(clazz.cast(this.verbose()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceRequest model) {
            this.dataSourceId(model.dataSourceId);
            this.verbose(model.verbose);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        public GetDataSourceRequest build() {
            return new GetDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDataSourceRequest> {
        public Builder dataSourceId(String var1);

        public Builder verbose(Boolean var1);
    }
}

