/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateMLModelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateMLModelRequest> {
    private final String mlModelId;
    private final String mlModelName;
    private final Float scoreThreshold;

    private UpdateMLModelRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.scoreThreshold = builder.scoreThreshold;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String mlModelName() {
        return this.mlModelName;
    }

    public Float scoreThreshold() {
        return this.scoreThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.mlModelName() == null ? 0 : this.mlModelName().hashCode());
        hashCode = 31 * hashCode + (this.scoreThreshold() == null ? 0 : this.scoreThreshold().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMLModelRequest)) {
            return false;
        }
        UpdateMLModelRequest other = (UpdateMLModelRequest)((Object)obj);
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.mlModelName() == null ^ this.mlModelName() == null) {
            return false;
        }
        if (other.mlModelName() != null && !other.mlModelName().equals(this.mlModelName())) {
            return false;
        }
        if (other.scoreThreshold() == null ^ this.scoreThreshold() == null) {
            return false;
        }
        return other.scoreThreshold() == null || other.scoreThreshold().equals(this.scoreThreshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.mlModelName() != null) {
            sb.append("MLModelName: ").append(this.mlModelName()).append(",");
        }
        if (this.scoreThreshold() != null) {
            sb.append("ScoreThreshold: ").append(this.scoreThreshold()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String mlModelId;
        private String mlModelName;
        private Float scoreThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMLModelRequest model) {
            this.setMLModelId(model.mlModelId);
            this.setMLModelName(model.mlModelName);
            this.setScoreThreshold(model.scoreThreshold);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return this.mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final Float getScoreThreshold() {
            return this.scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public UpdateMLModelRequest build() {
            return new UpdateMLModelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateMLModelRequest> {
        public Builder mlModelId(String var1);

        public Builder mlModelName(String var1);

        public Builder scoreThreshold(Float var1);
    }
}

