/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RedshiftMetadataMarshaller {
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDatabase").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASEUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseUserName").isBinary(false).build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").isBinary(false).build();
    private static final RedshiftMetadataMarshaller INSTANCE = new RedshiftMetadataMarshaller();

    private RedshiftMetadataMarshaller() {
    }

    public static RedshiftMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RedshiftMetadata redshiftMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)redshiftMetadata, (String)"redshiftMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)redshiftMetadata.redshiftDatabase(), REDSHIFTDATABASE_BINDING);
            protocolMarshaller.marshall((Object)redshiftMetadata.databaseUserName(), DATABASEUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)redshiftMetadata.selectSqlQuery(), SELECTSQLQUERY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

