/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RedshiftDataSpecMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASEINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseInformation").isBinary(false).build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DATABASECREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseCredentials").isBinary(false).build();
    private static final MarshallingInfo<String> S3STAGINGLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3StagingLocation").isBinary(false).build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").isBinary(false).build();
    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").isBinary(false).build();
    private static final MarshallingInfo<String> DATASCHEMAURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaUri").isBinary(false).build();
    private static final RedshiftDataSpecMarshaller INSTANCE = new RedshiftDataSpecMarshaller();

    private RedshiftDataSpecMarshaller() {
    }

    public static RedshiftDataSpecMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RedshiftDataSpec redshiftDataSpec, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)redshiftDataSpec, (String)"redshiftDataSpec");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)redshiftDataSpec.databaseInformation(), DATABASEINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)redshiftDataSpec.selectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall((Object)redshiftDataSpec.databaseCredentials(), DATABASECREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)redshiftDataSpec.s3StagingLocation(), S3STAGINGLOCATION_BINDING);
            protocolMarshaller.marshall((Object)redshiftDataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall((Object)redshiftDataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall((Object)redshiftDataSpec.dataSchemaUri(), DATASCHEMAURI_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

