/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RealtimeEndpointInfoMarshaller {
    private static final MarshallingInfo<Integer> PEAKREQUESTSPERSECOND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeakRequestsPerSecond").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointUrl").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointStatus").isBinary(false).build();
    private static final RealtimeEndpointInfoMarshaller INSTANCE = new RealtimeEndpointInfoMarshaller();

    private RealtimeEndpointInfoMarshaller() {
    }

    public static RealtimeEndpointInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RealtimeEndpointInfo realtimeEndpointInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)realtimeEndpointInfo, (String)"realtimeEndpointInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)realtimeEndpointInfo.peakRequestsPerSecond(), PEAKREQUESTSPERSECOND_BINDING);
            protocolMarshaller.marshall((Object)realtimeEndpointInfo.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)realtimeEndpointInfo.endpointUrl(), ENDPOINTURL_BINDING);
            protocolMarshaller.marshall((Object)realtimeEndpointInfo.endpointStatusAsString(), ENDPOINTSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

