/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RDSDatabaseCredentialsMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final RDSDatabaseCredentialsMarshaller INSTANCE = new RDSDatabaseCredentialsMarshaller();

    private RDSDatabaseCredentialsMarshaller() {
    }

    public static RDSDatabaseCredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSDatabaseCredentials rdsDatabaseCredentials, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rdsDatabaseCredentials, (String)"rdsDatabaseCredentials");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rdsDatabaseCredentials.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)rdsDatabaseCredentials.password(), PASSWORD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

