/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.Evaluation;

public class DescribeEvaluationsPublisher
implements SdkPublisher<DescribeEvaluationsResponse> {
    private final MachineLearningAsyncClient client;
    private final DescribeEvaluationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEvaluationsPublisher(MachineLearningAsyncClient client, DescribeEvaluationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEvaluationsPublisher(MachineLearningAsyncClient client, DescribeEvaluationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEvaluationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEvaluationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Evaluation> results() {
        Function<DescribeEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEvaluationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeEvaluationsPublisher resume(DescribeEvaluationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEvaluationsPublisher(this.client, (DescribeEvaluationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEvaluationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEvaluationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEvaluationsResponseFetcher
    implements AsyncPageFetcher<DescribeEvaluationsResponse> {
        private DescribeEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEvaluationsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeEvaluationsResponse> nextPage(DescribeEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEvaluationsPublisher.this.client.describeEvaluations(DescribeEvaluationsPublisher.this.firstRequest);
            }
            return DescribeEvaluationsPublisher.this.client.describeEvaluations((DescribeEvaluationsRequest)((Object)DescribeEvaluationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

