/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.machinelearning.model.RecordCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PredictRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PredictRequest> {
    private final String mlModelId;
    private final Map<String, String> record;
    private final String predictEndpoint;

    private PredictRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.record = builder.record;
        this.predictEndpoint = builder.predictEndpoint;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public Map<String, String> record() {
        return this.record;
    }

    public String predictEndpoint() {
        return this.predictEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.record() == null ? 0 : this.record().hashCode());
        hashCode = 31 * hashCode + (this.predictEndpoint() == null ? 0 : this.predictEndpoint().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictRequest)) {
            return false;
        }
        PredictRequest other = (PredictRequest)((Object)obj);
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.record() == null ^ this.record() == null) {
            return false;
        }
        if (other.record() != null && !other.record().equals(this.record())) {
            return false;
        }
        if (other.predictEndpoint() == null ^ this.predictEndpoint() == null) {
            return false;
        }
        return other.predictEndpoint() == null || other.predictEndpoint().equals(this.predictEndpoint());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.record() != null) {
            sb.append("Record: ").append(this.record()).append(",");
        }
        if (this.predictEndpoint() != null) {
            sb.append("PredictEndpoint: ").append(this.predictEndpoint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String mlModelId;
        private Map<String, String> record = new SdkInternalMap();
        private String predictEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictRequest model) {
            this.setMLModelId(model.mlModelId);
            this.setRecord(model.record);
            this.setPredictEndpoint(model.predictEndpoint);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Map<String, String> getRecord() {
            return this.record;
        }

        @Override
        public final Builder record(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        public final void setRecord(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
        }

        public final String getPredictEndpoint() {
            return this.predictEndpoint;
        }

        @Override
        public final Builder predictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
            return this;
        }

        public final void setPredictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
        }

        public PredictRequest build() {
            return new PredictRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PredictRequest> {
        public Builder mlModelId(String var1);

        public Builder record(Map<String, String> var1);

        public Builder predictEndpoint(String var1);
    }
}

