/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.internal;

import java.util.UUID;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMLModelRequest;

@ReviewBeforeRelease(value="They should be using the idempotency trait")
public class RandomIdHandler
extends RequestHandler {
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        if (request instanceof CreateBatchPredictionRequest) {
            CreateBatchPredictionRequest copy = (CreateBatchPredictionRequest)request;
            if (copy.batchPredictionDataSourceId() == null) {
                copy = (CreateBatchPredictionRequest)((Object)copy.toBuilder().batchPredictionDataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromRDSRequest) {
            CreateDataSourceFromRDSRequest copy = (CreateDataSourceFromRDSRequest)request;
            if (copy.dataSourceId() == null) {
                copy = (CreateDataSourceFromRDSRequest)((Object)copy.toBuilder().dataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromRedshiftRequest) {
            CreateDataSourceFromRedshiftRequest copy = (CreateDataSourceFromRedshiftRequest)request;
            if (copy.dataSourceId() == null) {
                copy = (CreateDataSourceFromRedshiftRequest)((Object)copy.toBuilder().dataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromS3Request) {
            CreateDataSourceFromS3Request copy = (CreateDataSourceFromS3Request)request;
            if (copy.dataSourceId() == null) {
                copy = (CreateDataSourceFromS3Request)((Object)copy.toBuilder().dataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateEvaluationRequest) {
            CreateEvaluationRequest copy = (CreateEvaluationRequest)request;
            if (copy.evaluationId() == null) {
                copy = (CreateEvaluationRequest)((Object)copy.toBuilder().evaluationId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateMLModelRequest) {
            CreateMLModelRequest copy = (CreateMLModelRequest)request;
            if (copy.mlModelId() == null) {
                copy = (CreateMLModelRequest)((Object)copy.toBuilder().mlModelId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        return request;
    }
}

