/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary;
import software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest;
import software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse;

public class ListBatchJobExecutionsPublisher
implements SdkPublisher<ListBatchJobExecutionsResponse> {
    private final M2AsyncClient client;
    private final ListBatchJobExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBatchJobExecutionsPublisher(M2AsyncClient client, ListBatchJobExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBatchJobExecutionsPublisher(M2AsyncClient client, ListBatchJobExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBatchJobExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBatchJobExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BatchJobExecutionSummary> batchJobExecutions() {
        Function<ListBatchJobExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchJobExecutions() != null) {
                return response.batchJobExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBatchJobExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBatchJobExecutionsResponseFetcher
    implements AsyncPageFetcher<ListBatchJobExecutionsResponse> {
        private ListBatchJobExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchJobExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBatchJobExecutionsResponse> nextPage(ListBatchJobExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchJobExecutionsPublisher.this.client.listBatchJobExecutions(ListBatchJobExecutionsPublisher.this.firstRequest);
            }
            return ListBatchJobExecutionsPublisher.this.client.listBatchJobExecutions((ListBatchJobExecutionsRequest)((Object)ListBatchJobExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

