/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationLifecycle {
    CREATING("Creating"),
    CREATED("Created"),
    AVAILABLE("Available"),
    READY("Ready"),
    STARTING("Starting"),
    RUNNING("Running"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    FAILED("Failed"),
    DELETING("Deleting"),
    DELETING_FROM_ENVIRONMENT("Deleting From Environment"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationLifecycle> VALUE_MAP;
    private final String value;

    private ApplicationLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationLifecycle> knownValues() {
        EnumSet<ApplicationLifecycle> knownValues = EnumSet.allOf(ApplicationLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationLifecycle.class, ApplicationLifecycle::toString);
    }
}

