/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.FileBatchJobDefinition;
import software.amazon.awssdk.services.m2.model.ScriptBatchJobDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchJobDefinition> {
    private static final SdkField<FileBatchJobDefinition> FILE_BATCH_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileBatchJobDefinition").getter(BatchJobDefinition.getter(BatchJobDefinition::fileBatchJobDefinition)).setter(BatchJobDefinition.setter(Builder::fileBatchJobDefinition)).constructor(FileBatchJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileBatchJobDefinition").build()}).build();
    private static final SdkField<ScriptBatchJobDefinition> SCRIPT_BATCH_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scriptBatchJobDefinition").getter(BatchJobDefinition.getter(BatchJobDefinition::scriptBatchJobDefinition)).setter(BatchJobDefinition.setter(Builder::scriptBatchJobDefinition)).constructor(ScriptBatchJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptBatchJobDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_BATCH_JOB_DEFINITION_FIELD, SCRIPT_BATCH_JOB_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final FileBatchJobDefinition fileBatchJobDefinition;
    private final ScriptBatchJobDefinition scriptBatchJobDefinition;
    private final Type type;

    private BatchJobDefinition(BuilderImpl builder) {
        this.fileBatchJobDefinition = builder.fileBatchJobDefinition;
        this.scriptBatchJobDefinition = builder.scriptBatchJobDefinition;
        this.type = builder.type;
    }

    public final FileBatchJobDefinition fileBatchJobDefinition() {
        return this.fileBatchJobDefinition;
    }

    public final ScriptBatchJobDefinition scriptBatchJobDefinition() {
        return this.scriptBatchJobDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileBatchJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptBatchJobDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchJobDefinition)) {
            return false;
        }
        BatchJobDefinition other = (BatchJobDefinition)obj;
        return Objects.equals(this.fileBatchJobDefinition(), other.fileBatchJobDefinition()) && Objects.equals(this.scriptBatchJobDefinition(), other.scriptBatchJobDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"BatchJobDefinition").add("FileBatchJobDefinition", (Object)this.fileBatchJobDefinition()).add("ScriptBatchJobDefinition", (Object)this.scriptBatchJobDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileBatchJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.fileBatchJobDefinition()));
            }
            case "scriptBatchJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.scriptBatchJobDefinition()));
            }
        }
        return Optional.empty();
    }

    public static BatchJobDefinition fromFileBatchJobDefinition(FileBatchJobDefinition fileBatchJobDefinition) {
        return (BatchJobDefinition)BatchJobDefinition.builder().fileBatchJobDefinition(fileBatchJobDefinition).build();
    }

    public static BatchJobDefinition fromFileBatchJobDefinition(Consumer<FileBatchJobDefinition.Builder> fileBatchJobDefinition) {
        FileBatchJobDefinition.Builder builder = FileBatchJobDefinition.builder();
        fileBatchJobDefinition.accept(builder);
        return BatchJobDefinition.fromFileBatchJobDefinition((FileBatchJobDefinition)builder.build());
    }

    public static BatchJobDefinition fromScriptBatchJobDefinition(ScriptBatchJobDefinition scriptBatchJobDefinition) {
        return (BatchJobDefinition)BatchJobDefinition.builder().scriptBatchJobDefinition(scriptBatchJobDefinition).build();
    }

    public static BatchJobDefinition fromScriptBatchJobDefinition(Consumer<ScriptBatchJobDefinition.Builder> scriptBatchJobDefinition) {
        ScriptBatchJobDefinition.Builder builder = ScriptBatchJobDefinition.builder();
        scriptBatchJobDefinition.accept(builder);
        return BatchJobDefinition.fromScriptBatchJobDefinition((ScriptBatchJobDefinition)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchJobDefinition, T> g) {
        return obj -> g.apply((BatchJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE_BATCH_JOB_DEFINITION,
        SCRIPT_BATCH_JOB_DEFINITION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FileBatchJobDefinition fileBatchJobDefinition;
        private ScriptBatchJobDefinition scriptBatchJobDefinition;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BatchJobDefinition model) {
            this.fileBatchJobDefinition(model.fileBatchJobDefinition);
            this.scriptBatchJobDefinition(model.scriptBatchJobDefinition);
        }

        public final FileBatchJobDefinition.Builder getFileBatchJobDefinition() {
            return this.fileBatchJobDefinition != null ? this.fileBatchJobDefinition.toBuilder() : null;
        }

        public final void setFileBatchJobDefinition(FileBatchJobDefinition.BuilderImpl fileBatchJobDefinition) {
            FileBatchJobDefinition oldValue = this.fileBatchJobDefinition;
            this.fileBatchJobDefinition = fileBatchJobDefinition != null ? fileBatchJobDefinition.build() : null;
            this.handleUnionValueChange(Type.FILE_BATCH_JOB_DEFINITION, oldValue, this.fileBatchJobDefinition);
        }

        @Override
        public final Builder fileBatchJobDefinition(FileBatchJobDefinition fileBatchJobDefinition) {
            FileBatchJobDefinition oldValue = this.fileBatchJobDefinition;
            this.fileBatchJobDefinition = fileBatchJobDefinition;
            this.handleUnionValueChange(Type.FILE_BATCH_JOB_DEFINITION, oldValue, this.fileBatchJobDefinition);
            return this;
        }

        public final ScriptBatchJobDefinition.Builder getScriptBatchJobDefinition() {
            return this.scriptBatchJobDefinition != null ? this.scriptBatchJobDefinition.toBuilder() : null;
        }

        public final void setScriptBatchJobDefinition(ScriptBatchJobDefinition.BuilderImpl scriptBatchJobDefinition) {
            ScriptBatchJobDefinition oldValue = this.scriptBatchJobDefinition;
            this.scriptBatchJobDefinition = scriptBatchJobDefinition != null ? scriptBatchJobDefinition.build() : null;
            this.handleUnionValueChange(Type.SCRIPT_BATCH_JOB_DEFINITION, oldValue, this.scriptBatchJobDefinition);
        }

        @Override
        public final Builder scriptBatchJobDefinition(ScriptBatchJobDefinition scriptBatchJobDefinition) {
            ScriptBatchJobDefinition oldValue = this.scriptBatchJobDefinition;
            this.scriptBatchJobDefinition = scriptBatchJobDefinition;
            this.handleUnionValueChange(Type.SCRIPT_BATCH_JOB_DEFINITION, oldValue, this.scriptBatchJobDefinition);
            return this;
        }

        public BatchJobDefinition build() {
            return new BatchJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchJobDefinition> {
        public Builder fileBatchJobDefinition(FileBatchJobDefinition var1);

        default public Builder fileBatchJobDefinition(Consumer<FileBatchJobDefinition.Builder> fileBatchJobDefinition) {
            return this.fileBatchJobDefinition((FileBatchJobDefinition)((FileBatchJobDefinition.Builder)FileBatchJobDefinition.builder().applyMutation(fileBatchJobDefinition)).build());
        }

        public Builder scriptBatchJobDefinition(ScriptBatchJobDefinition var1);

        default public Builder scriptBatchJobDefinition(Consumer<ScriptBatchJobDefinition.Builder> scriptBatchJobDefinition) {
            return this.scriptBatchJobDefinition((ScriptBatchJobDefinition)((ScriptBatchJobDefinition.Builder)ScriptBatchJobDefinition.builder().applyMutation(scriptBatchJobDefinition)).build());
        }
    }
}

