/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ConflictException;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.InternalServerException;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsException;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutmetrics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.TooManyRequestsException;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ValidationException;
import software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable;
import software.amazon.awssdk.services.lookoutmetrics.transform.ActivateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.BackTestAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.CreateAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.CreateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.CreateMetricSetRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DeactivateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DeleteAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DeleteAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeAnomalyDetectionExecutionsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DescribeMetricSetRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.DetectMetricSetConfigRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetAnomalyGroupRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetDataQualityMetricsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetFeedbackRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.GetSampleDataRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAlertsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyGroupRelatedMetricsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyGroupSummariesRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListAnomalyGroupTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListMetricSetsRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UpdateAlertRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UpdateAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.lookoutmetrics.transform.UpdateMetricSetRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLookoutMetricsClient
implements LookoutMetricsClient {
    private static final Logger log = Logger.loggerFor(DefaultLookoutMetricsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLookoutMetricsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "lookoutmetrics";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivateAnomalyDetectorResponse activateAnomalyDetector(ActivateAnomalyDetectorRequest activateAnomalyDetectorRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, activateAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ActivateAnomalyDetector");
            ActivateAnomalyDetectorResponse activateAnomalyDetectorResponse = (ActivateAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)activateAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ActivateAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return activateAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$activateAnomalyDetector$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackTestAnomalyDetectorResponse backTestAnomalyDetector(BackTestAnomalyDetectorRequest backTestAnomalyDetectorRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BackTestAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, backTestAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BackTestAnomalyDetector");
            BackTestAnomalyDetectorResponse backTestAnomalyDetectorResponse = (BackTestAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BackTestAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)backTestAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BackTestAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return backTestAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$backTestAnomalyDetector$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAlertResponse createAlert(CreateAlertRequest createAlertRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAlertResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, createAlertRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlert");
            CreateAlertResponse createAlertResponse = (CreateAlertResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlert").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAlertRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAlertRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAlertResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$createAlert$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnomalyDetectorResponse createAnomalyDetector(CreateAnomalyDetectorRequest createAnomalyDetectorRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, createAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalyDetector");
            CreateAnomalyDetectorResponse createAnomalyDetectorResponse = (CreateAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$createAnomalyDetector$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMetricSetResponse createMetricSet(CreateMetricSetRequest createMetricSetRequest) throws ConflictException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMetricSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, createMetricSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMetricSet");
            CreateMetricSetResponse createMetricSetResponse = (CreateMetricSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMetricSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMetricSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMetricSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMetricSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$createMetricSet$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeactivateAnomalyDetectorResponse deactivateAnomalyDetector(DeactivateAnomalyDetectorRequest deactivateAnomalyDetectorRequest) throws ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivateAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, deactivateAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeactivateAnomalyDetector");
            DeactivateAnomalyDetectorResponse deactivateAnomalyDetectorResponse = (DeactivateAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivateAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deactivateAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeactivateAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deactivateAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$deactivateAnomalyDetector$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAlertResponse deleteAlert(DeleteAlertRequest deleteAlertRequest) throws ResourceNotFoundException, ValidationException, TooManyRequestsException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAlertResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, deleteAlertRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlert");
            DeleteAlertResponse deleteAlertResponse = (DeleteAlertResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlert").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAlertRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAlertRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAlertResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$deleteAlert$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnomalyDetectorResponse deleteAnomalyDetector(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest) throws ResourceNotFoundException, ValidationException, ConflictException, TooManyRequestsException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, deleteAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalyDetector");
            DeleteAnomalyDetectorResponse deleteAnomalyDetectorResponse = (DeleteAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$deleteAnomalyDetector$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlertResponse describeAlert(DescribeAlertRequest describeAlertRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlertResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, describeAlertRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlert");
            DescribeAlertResponse describeAlertResponse = (DescribeAlertResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlert").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAlertRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlertRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlertResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$describeAlert$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnomalyDetectionExecutionsResponse describeAnomalyDetectionExecutions(DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAnomalyDetectionExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, describeAnomalyDetectionExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAnomalyDetectionExecutions");
            DescribeAnomalyDetectionExecutionsResponse describeAnomalyDetectionExecutionsResponse = (DescribeAnomalyDetectionExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnomalyDetectionExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAnomalyDetectionExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAnomalyDetectionExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAnomalyDetectionExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$describeAnomalyDetectionExecutions$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeAnomalyDetectionExecutionsIterable describeAnomalyDetectionExecutionsPaginator(DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new DescribeAnomalyDetectionExecutionsIterable(this, this.applyPaginatorUserAgent(describeAnomalyDetectionExecutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnomalyDetectorResponse describeAnomalyDetector(DescribeAnomalyDetectorRequest describeAnomalyDetectorRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, describeAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAnomalyDetector");
            DescribeAnomalyDetectorResponse describeAnomalyDetectorResponse = (DescribeAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$describeAnomalyDetector$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetricSetResponse describeMetricSet(DescribeMetricSetRequest describeMetricSetRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetricSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, describeMetricSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetricSet");
            DescribeMetricSetResponse describeMetricSetResponse = (DescribeMetricSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMetricSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetricSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetricSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$describeMetricSet$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectMetricSetConfigResponse detectMetricSetConfig(DetectMetricSetConfigRequest detectMetricSetConfigRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectMetricSetConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, detectMetricSetConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectMetricSetConfig");
            DetectMetricSetConfigResponse detectMetricSetConfigResponse = (DetectMetricSetConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectMetricSetConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectMetricSetConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectMetricSetConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectMetricSetConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$detectMetricSetConfig$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomalyGroupResponse getAnomalyGroup(GetAnomalyGroupRequest getAnomalyGroupRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalyGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, getAnomalyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalyGroup");
            GetAnomalyGroupResponse getAnomalyGroupResponse = (GetAnomalyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalyGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnomalyGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomalyGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomalyGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$getAnomalyGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataQualityMetricsResponse getDataQualityMetrics(GetDataQualityMetricsRequest getDataQualityMetricsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataQualityMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, getDataQualityMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataQualityMetrics");
            GetDataQualityMetricsResponse getDataQualityMetricsResponse = (GetDataQualityMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataQualityMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataQualityMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataQualityMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataQualityMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$getDataQualityMetrics$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFeedbackResponse getFeedback(GetFeedbackRequest getFeedbackRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, getFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFeedback");
            GetFeedbackResponse getFeedbackResponse = (GetFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$getFeedback$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetFeedbackIterable getFeedbackPaginator(GetFeedbackRequest getFeedbackRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new GetFeedbackIterable(this, this.applyPaginatorUserAgent(getFeedbackRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSampleDataResponse getSampleData(GetSampleDataRequest getSampleDataRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSampleDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, getSampleDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSampleData");
            GetSampleDataResponse getSampleDataResponse = (GetSampleDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSampleData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSampleDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSampleDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSampleDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$getSampleData$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws ResourceNotFoundException, AccessDeniedException, InternalServerException, TooManyRequestsException, ValidationException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAlertsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listAlertsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAlerts");
            ListAlertsResponse listAlertsResponse = (ListAlertsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAlerts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAlertsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAlertsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAlertsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listAlerts$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAlertsIterable listAlertsPaginator(ListAlertsRequest listAlertsRequest) throws ResourceNotFoundException, AccessDeniedException, InternalServerException, TooManyRequestsException, ValidationException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListAlertsIterable(this, this.applyPaginatorUserAgent(listAlertsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnomalyDetectorsResponse listAnomalyDetectors(ListAnomalyDetectorsRequest listAnomalyDetectorsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomalyDetectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listAnomalyDetectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomalyDetectors");
            ListAnomalyDetectorsResponse listAnomalyDetectorsResponse = (ListAnomalyDetectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomalyDetectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnomalyDetectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnomalyDetectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnomalyDetectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listAnomalyDetectors$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnomalyDetectorsIterable listAnomalyDetectorsPaginator(ListAnomalyDetectorsRequest listAnomalyDetectorsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListAnomalyDetectorsIterable(this, this.applyPaginatorUserAgent(listAnomalyDetectorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnomalyGroupRelatedMetricsResponse listAnomalyGroupRelatedMetrics(ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomalyGroupRelatedMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listAnomalyGroupRelatedMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomalyGroupRelatedMetrics");
            ListAnomalyGroupRelatedMetricsResponse listAnomalyGroupRelatedMetricsResponse = (ListAnomalyGroupRelatedMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomalyGroupRelatedMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnomalyGroupRelatedMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnomalyGroupRelatedMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnomalyGroupRelatedMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listAnomalyGroupRelatedMetrics$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnomalyGroupRelatedMetricsIterable listAnomalyGroupRelatedMetricsPaginator(ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListAnomalyGroupRelatedMetricsIterable(this, this.applyPaginatorUserAgent(listAnomalyGroupRelatedMetricsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnomalyGroupSummariesResponse listAnomalyGroupSummaries(ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomalyGroupSummariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listAnomalyGroupSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomalyGroupSummaries");
            ListAnomalyGroupSummariesResponse listAnomalyGroupSummariesResponse = (ListAnomalyGroupSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomalyGroupSummaries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnomalyGroupSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnomalyGroupSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnomalyGroupSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listAnomalyGroupSummaries$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnomalyGroupSummariesIterable listAnomalyGroupSummariesPaginator(ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListAnomalyGroupSummariesIterable(this, this.applyPaginatorUserAgent(listAnomalyGroupSummariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnomalyGroupTimeSeriesResponse listAnomalyGroupTimeSeries(ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) throws InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnomalyGroupTimeSeriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listAnomalyGroupTimeSeriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnomalyGroupTimeSeries");
            ListAnomalyGroupTimeSeriesResponse listAnomalyGroupTimeSeriesResponse = (ListAnomalyGroupTimeSeriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnomalyGroupTimeSeries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnomalyGroupTimeSeriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnomalyGroupTimeSeriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnomalyGroupTimeSeriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listAnomalyGroupTimeSeries$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnomalyGroupTimeSeriesIterable listAnomalyGroupTimeSeriesPaginator(ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) throws InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListAnomalyGroupTimeSeriesIterable(this, this.applyPaginatorUserAgent(listAnomalyGroupTimeSeriesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricSetsResponse listMetricSets(ListMetricSetsRequest listMetricSetsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMetricSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listMetricSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetricSets");
            ListMetricSetsResponse listMetricSetsResponse = (ListMetricSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetricSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMetricSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMetricSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMetricSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listMetricSets$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMetricSetsIterable listMetricSetsPaginator(ListMetricSetsRequest listMetricSetsRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListMetricSetsIterable(this, this.applyPaginatorUserAgent(listMetricSetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$listTagsForResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, putFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutFeedback");
            PutFeedbackResponse putFeedbackResponse = (PutFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$putFeedback$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$tagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$untagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAlertResponse updateAlert(UpdateAlertRequest updateAlertRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAlertResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, updateAlertRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAlert");
            UpdateAlertResponse updateAlertResponse = (UpdateAlertResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAlert").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAlertRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAlertRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAlertResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$updateAlert$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnomalyDetectorResponse updateAnomalyDetector(UpdateAnomalyDetectorRequest updateAnomalyDetectorRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalyDetectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, updateAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalyDetector");
            UpdateAnomalyDetectorResponse updateAnomalyDetectorResponse = (UpdateAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$updateAnomalyDetector$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMetricSetResponse updateMetricSet(UpdateMetricSetRequest updateMetricSetRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutMetricsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMetricSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLookoutMetricsClient.resolveMetricPublishers(this.clientConfiguration, updateMetricSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutMetrics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMetricSet");
            UpdateMetricSetResponse updateMetricSetResponse = (UpdateMetricSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMetricSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMetricSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMetricSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMetricSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLookoutMetricsClient.lambda$updateMetricSet$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LookoutMetricsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends LookoutMetricsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LookoutMetricsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateMetricSet$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalyDetector$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAlert$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putFeedback$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetricSets$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnomalyGroupTimeSeries$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnomalyGroupSummaries$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnomalyGroupRelatedMetrics$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnomalyDetectors$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAlerts$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSampleData$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFeedback$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataQualityMetrics$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalyGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectMetricSetConfig$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMetricSet$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAnomalyDetector$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAnomalyDetectionExecutions$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlert$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalyDetector$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlert$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deactivateAnomalyDetector$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMetricSet$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalyDetector$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAlert$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$backTestAnomalyDetector$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$activateAnomalyDetector$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

