/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse;

public class ListInferenceEventsPublisher
implements SdkPublisher<ListInferenceEventsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListInferenceEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceEventsPublisher(LookoutEquipmentAsyncClient client, ListInferenceEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceEventsPublisher(LookoutEquipmentAsyncClient client, ListInferenceEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInferenceEventsResponseFetcher
    implements AsyncPageFetcher<ListInferenceEventsResponse> {
        private ListInferenceEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceEventsResponse> nextPage(ListInferenceEventsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceEventsPublisher.this.client.listInferenceEvents(ListInferenceEventsPublisher.this.firstRequest);
            }
            return ListInferenceEventsPublisher.this.client.listInferenceEvents((ListInferenceEventsRequest)((Object)ListInferenceEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

