/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.Circle;
import software.amazon.awssdk.services.location.model.LinearRingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeofenceGeometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeofenceGeometry> {
    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Polygon").getter(GeofenceGeometry.getter(GeofenceGeometry::polygon)).setter(GeofenceGeometry.setter(Builder::polygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Circle> CIRCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Circle").getter(GeofenceGeometry.getter(GeofenceGeometry::circle)).setter(GeofenceGeometry.setter(Builder::circle)).constructor(Circle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Circle").build()}).build();
    private static final SdkField<SdkBytes> GEOBUF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Geobuf").getter(GeofenceGeometry.getter(GeofenceGeometry::geobuf)).setter(GeofenceGeometry.setter(Builder::geobuf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geobuf").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLYGON_FIELD, CIRCLE_FIELD, GEOBUF_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeofenceGeometry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<List<List<Double>>> polygon;
    private final Circle circle;
    private final SdkBytes geobuf;

    private GeofenceGeometry(BuilderImpl builder) {
        this.polygon = builder.polygon;
        this.circle = builder.circle;
        this.geobuf = builder.geobuf;
    }

    public final boolean hasPolygon() {
        return this.polygon != null && !(this.polygon instanceof SdkAutoConstructList);
    }

    public final List<List<List<Double>>> polygon() {
        return this.polygon;
    }

    public final Circle circle() {
        return this.circle;
    }

    public final SdkBytes geobuf() {
        return this.geobuf;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolygon() ? this.polygon() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.circle());
        hashCode = 31 * hashCode + Objects.hashCode(this.geobuf());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeofenceGeometry)) {
            return false;
        }
        GeofenceGeometry other = (GeofenceGeometry)obj;
        return this.hasPolygon() == other.hasPolygon() && Objects.equals(this.polygon(), other.polygon()) && Objects.equals(this.circle(), other.circle()) && Objects.equals(this.geobuf(), other.geobuf());
    }

    public final String toString() {
        return ToString.builder((String)"GeofenceGeometry").add("Polygon", (Object)(this.polygon() == null ? null : "*** Sensitive Data Redacted ***")).add("Circle", (Object)(this.circle() == null ? null : "*** Sensitive Data Redacted ***")).add("Geobuf", (Object)(this.geobuf() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Polygon": {
                return Optional.ofNullable(clazz.cast(this.polygon()));
            }
            case "Circle": {
                return Optional.ofNullable(clazz.cast(this.circle()));
            }
            case "Geobuf": {
                return Optional.ofNullable(clazz.cast(this.geobuf()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Polygon", POLYGON_FIELD);
        map.put("Circle", CIRCLE_FIELD);
        map.put("Geobuf", GEOBUF_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeofenceGeometry, T> g) {
        return obj -> g.apply((GeofenceGeometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();
        private Circle circle;
        private SdkBytes geobuf;

        private BuilderImpl() {
        }

        private BuilderImpl(GeofenceGeometry model) {
            this.polygon(model.polygon);
            this.circle(model.circle);
            this.geobuf(model.geobuf);
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (this.polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return this.polygon;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = LinearRingsCopier.copy(polygon);
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = LinearRingsCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>> ... polygon) {
            this.polygon((Collection<? extends Collection<? extends Collection<Double>>>)Arrays.asList(polygon));
            return this;
        }

        public final Circle.Builder getCircle() {
            return this.circle != null ? this.circle.toBuilder() : null;
        }

        public final void setCircle(Circle.BuilderImpl circle) {
            this.circle = circle != null ? circle.build() : null;
        }

        @Override
        public final Builder circle(Circle circle) {
            this.circle = circle;
            return this;
        }

        public final ByteBuffer getGeobuf() {
            return this.geobuf == null ? null : this.geobuf.asByteBuffer();
        }

        public final void setGeobuf(ByteBuffer geobuf) {
            this.geobuf(geobuf == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)geobuf));
        }

        @Override
        public final Builder geobuf(SdkBytes geobuf) {
            this.geobuf = geobuf;
            return this;
        }

        public GeofenceGeometry build() {
            return new GeofenceGeometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeofenceGeometry> {
        public Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> var1);

        public Builder polygon(Collection<? extends Collection<Double>> ... var1);

        public Builder circle(Circle var1);

        default public Builder circle(Consumer<Circle.Builder> circle) {
            return this.circle((Circle)((Circle.Builder)Circle.builder().applyMutation(circle)).build());
        }

        public Builder geobuf(SdkBytes var1);
    }
}

