/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGeofenceCollectionRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CreateGeofenceCollectionRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(CreateGeofenceCollectionRequest.getter(CreateGeofenceCollectionRequest::collectionName)).setter(CreateGeofenceCollectionRequest.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(CreateGeofenceCollectionRequest.getter(CreateGeofenceCollectionRequest::pricingPlanAsString)).setter(CreateGeofenceCollectionRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(CreateGeofenceCollectionRequest.getter(CreateGeofenceCollectionRequest::pricingPlanDataSource)).setter(CreateGeofenceCollectionRequest.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateGeofenceCollectionRequest.getter(CreateGeofenceCollectionRequest::description)).setter(CreateGeofenceCollectionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateGeofenceCollectionRequest.getter(CreateGeofenceCollectionRequest::tags)).setter(CreateGeofenceCollectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateGeofenceCollectionRequest.getter(CreateGeofenceCollectionRequest::kmsKeyId)).setter(CreateGeofenceCollectionRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD));
    private final String collectionName;
    private final String pricingPlan;
    private final String pricingPlanDataSource;
    private final String description;
    private final Map<String, String> tags;
    private final String kmsKeyId;

    private CreateGeofenceCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.description = builder.description;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeofenceCollectionRequest)) {
            return false;
        }
        CreateGeofenceCollectionRequest other = (CreateGeofenceCollectionRequest)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGeofenceCollectionRequest").add("CollectionName", (Object)this.collectionName()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGeofenceCollectionRequest, T> g) {
        return obj -> g.apply((CreateGeofenceCollectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String collectionName;
        private String pricingPlan;
        private String pricingPlanDataSource;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeofenceCollectionRequest model) {
            super(model);
            this.collectionName(model.collectionName);
            this.pricingPlan(model.pricingPlan);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.description(model.description);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGeofenceCollectionRequest build() {
            return new CreateGeofenceCollectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGeofenceCollectionRequest> {
        public Builder collectionName(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

