/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.InstancePortState;
import software.amazon.awssdk.services.lightsail.model.InstancePortStateListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstancePortStatesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetInstancePortStatesResponse> {
    private static final SdkField<List<InstancePortState>> PORT_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetInstancePortStatesResponse.getter(GetInstancePortStatesResponse::portStates)).setter(GetInstancePortStatesResponse.setter(Builder::portStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePortState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_STATES_FIELD));
    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        super(builder);
        this.portStates = builder.portStates;
    }

    public List<InstancePortState> portStates() {
        return this.portStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse)((Object)obj);
        return Objects.equals(this.portStates(), other.portStates());
    }

    public String toString() {
        return ToString.builder((String)"GetInstancePortStatesResponse").add("PortStates", this.portStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portStates": {
                return Optional.ofNullable(clazz.cast(this.portStates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstancePortStatesResponse, T> g) {
        return obj -> g.apply((GetInstancePortStatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<InstancePortState> portStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            super(model);
            this.portStates(model.portStates);
        }

        public final Collection<InstancePortState.Builder> getPortStates() {
            return this.portStates != null ? (Collection)this.portStates.stream().map(InstancePortState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState ... portStates) {
            this.portStates(Arrays.asList(portStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(Consumer<InstancePortState.Builder> ... portStates) {
            this.portStates(Stream.of(portStates).map(c -> (InstancePortState)((InstancePortState.Builder)InstancePortState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState.BuilderImpl> portStates) {
            this.portStates = InstancePortStateListCopier.copyFromBuilder(portStates);
        }

        @Override
        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        public Builder portStates(Collection<InstancePortState> var1);

        public Builder portStates(InstancePortState ... var1);

        public Builder portStates(Consumer<InstancePortState.Builder> ... var1);
    }
}

