/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.DestinationInfo;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo;
import software.amazon.awssdk.services.lightsail.model.RecordState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportSnapshotRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportSnapshotRecord> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::name)).setter(ExportSnapshotRecord.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::arn)).setter(ExportSnapshotRecord.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::createdAt)).setter(ExportSnapshotRecord.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::location)).setter(ExportSnapshotRecord.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::resourceTypeAsString)).setter(ExportSnapshotRecord.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::stateAsString)).setter(ExportSnapshotRecord.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<ExportSnapshotRecordSourceInfo> SOURCE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::sourceInfo)).setter(ExportSnapshotRecord.setter(Builder::sourceInfo)).constructor(ExportSnapshotRecordSourceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInfo").build()}).build();
    private static final SdkField<DestinationInfo> DESTINATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExportSnapshotRecord.getter(ExportSnapshotRecord::destinationInfo)).setter(ExportSnapshotRecord.setter(Builder::destinationInfo)).constructor(DestinationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, STATE_FIELD, SOURCE_INFO_FIELD, DESTINATION_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String state;
    private final ExportSnapshotRecordSourceInfo sourceInfo;
    private final DestinationInfo destinationInfo;

    private ExportSnapshotRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.sourceInfo = builder.sourceInfo;
        this.destinationInfo = builder.destinationInfo;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public RecordState state() {
        return RecordState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ExportSnapshotRecordSourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    public DestinationInfo destinationInfo() {
        return this.destinationInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSnapshotRecord)) {
            return false;
        }
        ExportSnapshotRecord other = (ExportSnapshotRecord)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.sourceInfo(), other.sourceInfo()) && Objects.equals(this.destinationInfo(), other.destinationInfo());
    }

    public String toString() {
        return ToString.builder((String)"ExportSnapshotRecord").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("State", (Object)this.stateAsString()).add("SourceInfo", (Object)this.sourceInfo()).add("DestinationInfo", (Object)this.destinationInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "sourceInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceInfo()));
            }
            case "destinationInfo": {
                return Optional.ofNullable(clazz.cast(this.destinationInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSnapshotRecord, T> g) {
        return obj -> g.apply((ExportSnapshotRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String state;
        private ExportSnapshotRecordSourceInfo sourceInfo;
        private DestinationInfo destinationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSnapshotRecord model) {
            this.name(model.name);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.state(model.state);
            this.sourceInfo(model.sourceInfo);
            this.destinationInfo(model.destinationInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RecordState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ExportSnapshotRecordSourceInfo.Builder getSourceInfo() {
            return this.sourceInfo != null ? this.sourceInfo.toBuilder() : null;
        }

        @Override
        public final Builder sourceInfo(ExportSnapshotRecordSourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public final void setSourceInfo(ExportSnapshotRecordSourceInfo.BuilderImpl sourceInfo) {
            this.sourceInfo = sourceInfo != null ? sourceInfo.build() : null;
        }

        public final DestinationInfo.Builder getDestinationInfo() {
            return this.destinationInfo != null ? this.destinationInfo.toBuilder() : null;
        }

        @Override
        public final Builder destinationInfo(DestinationInfo destinationInfo) {
            this.destinationInfo = destinationInfo;
            return this;
        }

        public final void setDestinationInfo(DestinationInfo.BuilderImpl destinationInfo) {
            this.destinationInfo = destinationInfo != null ? destinationInfo.build() : null;
        }

        public ExportSnapshotRecord build() {
            return new ExportSnapshotRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportSnapshotRecord> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder state(String var1);

        public Builder state(RecordState var1);

        public Builder sourceInfo(ExportSnapshotRecordSourceInfo var1);

        default public Builder sourceInfo(Consumer<ExportSnapshotRecordSourceInfo.Builder> sourceInfo) {
            return this.sourceInfo((ExportSnapshotRecordSourceInfo)((ExportSnapshotRecordSourceInfo.Builder)ExportSnapshotRecordSourceInfo.builder().applyMutation(sourceInfo)).build());
        }

        public Builder destinationInfo(DestinationInfo var1);

        default public Builder destinationInfo(Consumer<DestinationInfo.Builder> destinationInfo) {
            return this.destinationInfo((DestinationInfo)((DestinationInfo.Builder)DestinationInfo.builder().applyMutation(destinationInfo)).build());
        }
    }
}

