/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.Container;
import software.amazon.awssdk.services.lightsail.model.ContainerMapCopier;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerServiceDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerServiceDeployment> {
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("version").getter(ContainerServiceDeployment.getter(ContainerServiceDeployment::version)).setter(ContainerServiceDeployment.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ContainerServiceDeployment.getter(ContainerServiceDeployment::stateAsString)).setter(ContainerServiceDeployment.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("containers").getter(ContainerServiceDeployment.getter(ContainerServiceDeployment::containers)).setter(ContainerServiceDeployment.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ContainerServiceEndpoint> PUBLIC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("publicEndpoint").getter(ContainerServiceDeployment.getter(ContainerServiceDeployment::publicEndpoint)).setter(ContainerServiceDeployment.setter(Builder::publicEndpoint)).constructor(ContainerServiceEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicEndpoint").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ContainerServiceDeployment.getter(ContainerServiceDeployment::createdAt)).setter(ContainerServiceDeployment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, STATE_FIELD, CONTAINERS_FIELD, PUBLIC_ENDPOINT_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("version", VERSION_FIELD);
            this.put("state", STATE_FIELD);
            this.put("containers", CONTAINERS_FIELD);
            this.put("publicEndpoint", PUBLIC_ENDPOINT_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer version;
    private final String state;
    private final Map<String, Container> containers;
    private final ContainerServiceEndpoint publicEndpoint;
    private final Instant createdAt;

    private ContainerServiceDeployment(BuilderImpl builder) {
        this.version = builder.version;
        this.state = builder.state;
        this.containers = builder.containers;
        this.publicEndpoint = builder.publicEndpoint;
        this.createdAt = builder.createdAt;
    }

    public final Integer version() {
        return this.version;
    }

    public final ContainerServiceDeploymentState state() {
        return ContainerServiceDeploymentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructMap);
    }

    public final Map<String, Container> containers() {
        return this.containers;
    }

    public final ContainerServiceEndpoint publicEndpoint() {
        return this.publicEndpoint;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceDeployment)) {
            return false;
        }
        ContainerServiceDeployment other = (ContainerServiceDeployment)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.publicEndpoint(), other.publicEndpoint()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerServiceDeployment").add("Version", (Object)this.version()).add("State", (Object)this.stateAsString()).add("Containers", this.hasContainers() ? this.containers() : null).add("PublicEndpoint", (Object)this.publicEndpoint()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "publicEndpoint": {
                return Optional.ofNullable(clazz.cast(this.publicEndpoint()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceDeployment, T> g) {
        return obj -> g.apply((ContainerServiceDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer version;
        private String state;
        private Map<String, Container> containers = DefaultSdkAutoConstructMap.getInstance();
        private ContainerServiceEndpoint publicEndpoint;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceDeployment model) {
            this.version(model.version);
            this.state(model.state);
            this.containers(model.containers);
            this.publicEndpoint(model.publicEndpoint);
            this.createdAt(model.createdAt);
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ContainerServiceDeploymentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, Container.Builder> getContainers() {
            Map<String, Container.Builder> result = ContainerMapCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setContainers(Map<String, Container.BuilderImpl> containers) {
            this.containers = ContainerMapCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Map<String, Container> containers) {
            this.containers = ContainerMapCopier.copy(containers);
            return this;
        }

        public final ContainerServiceEndpoint.Builder getPublicEndpoint() {
            return this.publicEndpoint != null ? this.publicEndpoint.toBuilder() : null;
        }

        public final void setPublicEndpoint(ContainerServiceEndpoint.BuilderImpl publicEndpoint) {
            this.publicEndpoint = publicEndpoint != null ? publicEndpoint.build() : null;
        }

        @Override
        public final Builder publicEndpoint(ContainerServiceEndpoint publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ContainerServiceDeployment build() {
            return new ContainerServiceDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerServiceDeployment> {
        public Builder version(Integer var1);

        public Builder state(String var1);

        public Builder state(ContainerServiceDeploymentState var1);

        public Builder containers(Map<String, Container> var1);

        public Builder publicEndpoint(ContainerServiceEndpoint var1);

        default public Builder publicEndpoint(Consumer<ContainerServiceEndpoint.Builder> publicEndpoint) {
            return this.publicEndpoint((ContainerServiceEndpoint)((ContainerServiceEndpoint.Builder)ContainerServiceEndpoint.builder().applyMutation(publicEndpoint)).build());
        }

        public Builder createdAt(Instant var1);
    }
}

