/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePublicDomainsCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerServiceRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateContainerServiceRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(CreateContainerServiceRequest.getter(CreateContainerServiceRequest::serviceName)).setter(CreateContainerServiceRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> POWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("power").getter(CreateContainerServiceRequest.getter(CreateContainerServiceRequest::powerAsString)).setter(CreateContainerServiceRequest.setter(Builder::power)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("power").build()}).build();
    private static final SdkField<Integer> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scale").getter(CreateContainerServiceRequest.getter(CreateContainerServiceRequest::scale)).setter(CreateContainerServiceRequest.setter(Builder::scale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateContainerServiceRequest.getter(CreateContainerServiceRequest::tags)).setter(CreateContainerServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> PUBLIC_DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("publicDomainNames").getter(CreateContainerServiceRequest.getter(CreateContainerServiceRequest::publicDomainNames)).setter(CreateContainerServiceRequest.setter(Builder::publicDomainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDomainNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<ContainerServiceDeploymentRequest> DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deployment").getter(CreateContainerServiceRequest.getter(CreateContainerServiceRequest::deployment)).setter(CreateContainerServiceRequest.setter(Builder::deployment)).constructor(ContainerServiceDeploymentRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, POWER_FIELD, SCALE_FIELD, TAGS_FIELD, PUBLIC_DOMAIN_NAMES_FIELD, DEPLOYMENT_FIELD));
    private final String serviceName;
    private final String power;
    private final Integer scale;
    private final List<Tag> tags;
    private final Map<String, List<String>> publicDomainNames;
    private final ContainerServiceDeploymentRequest deployment;

    private CreateContainerServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.power = builder.power;
        this.scale = builder.scale;
        this.tags = builder.tags;
        this.publicDomainNames = builder.publicDomainNames;
        this.deployment = builder.deployment;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final ContainerServicePowerName power() {
        return ContainerServicePowerName.fromValue(this.power);
    }

    public final String powerAsString() {
        return this.power;
    }

    public final Integer scale() {
        return this.scale;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasPublicDomainNames() {
        return this.publicDomainNames != null && !(this.publicDomainNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> publicDomainNames() {
        return this.publicDomainNames;
    }

    public final ContainerServiceDeploymentRequest deployment() {
        return this.deployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicDomainNames() ? this.publicDomainNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deployment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerServiceRequest)) {
            return false;
        }
        CreateContainerServiceRequest other = (CreateContainerServiceRequest)((Object)obj);
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.powerAsString(), other.powerAsString()) && Objects.equals(this.scale(), other.scale()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasPublicDomainNames() == other.hasPublicDomainNames() && Objects.equals(this.publicDomainNames(), other.publicDomainNames()) && Objects.equals(this.deployment(), other.deployment());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContainerServiceRequest").add("ServiceName", (Object)this.serviceName()).add("Power", (Object)this.powerAsString()).add("Scale", (Object)this.scale()).add("Tags", this.hasTags() ? this.tags() : null).add("PublicDomainNames", this.hasPublicDomainNames() ? this.publicDomainNames() : null).add("Deployment", (Object)this.deployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "power": {
                return Optional.ofNullable(clazz.cast(this.powerAsString()));
            }
            case "scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "publicDomainNames": {
                return Optional.ofNullable(clazz.cast(this.publicDomainNames()));
            }
            case "deployment": {
                return Optional.ofNullable(clazz.cast(this.deployment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerServiceRequest, T> g) {
        return obj -> g.apply((CreateContainerServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String serviceName;
        private String power;
        private Integer scale;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> publicDomainNames = DefaultSdkAutoConstructMap.getInstance();
        private ContainerServiceDeploymentRequest deployment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerServiceRequest model) {
            super(model);
            this.serviceName(model.serviceName);
            this.power(model.power);
            this.scale(model.scale);
            this.tags(model.tags);
            this.publicDomainNames(model.publicDomainNames);
            this.deployment(model.deployment);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getPower() {
            return this.power;
        }

        @Override
        public final Builder power(String power) {
            this.power = power;
            return this;
        }

        @Override
        public final Builder power(ContainerServicePowerName power) {
            this.power(power == null ? null : power.toString());
            return this;
        }

        public final void setPower(String power) {
            this.power = power;
        }

        public final Integer getScale() {
            return this.scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Map<String, ? extends Collection<String>> getPublicDomainNames() {
            if (this.publicDomainNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.publicDomainNames;
        }

        @Override
        public final Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
            return this;
        }

        public final void setPublicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
        }

        public final ContainerServiceDeploymentRequest.Builder getDeployment() {
            return this.deployment != null ? this.deployment.toBuilder() : null;
        }

        @Override
        public final Builder deployment(ContainerServiceDeploymentRequest deployment) {
            this.deployment = deployment;
            return this;
        }

        public final void setDeployment(ContainerServiceDeploymentRequest.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerServiceRequest build() {
            return new CreateContainerServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerServiceRequest> {
        public Builder serviceName(String var1);

        public Builder power(String var1);

        public Builder power(ContainerServicePowerName var1);

        public Builder scale(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder publicDomainNames(Map<String, ? extends Collection<String>> var1);

        public Builder deployment(ContainerServiceDeploymentRequest var1);

        default public Builder deployment(Consumer<ContainerServiceDeploymentRequest.Builder> deployment) {
            return this.deployment((ContainerServiceDeploymentRequest)((ContainerServiceDeploymentRequest.Builder)ContainerServiceDeploymentRequest.builder().applyMutation(deployment)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

