/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse;

public class ListUserAssociationsPublisher
implements SdkPublisher<ListUserAssociationsResponse> {
    private final LicenseManagerUserSubscriptionsAsyncClient client;
    private final ListUserAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserAssociationsPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListUserAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserAssociationsPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListUserAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceUserSummary> instanceUserSummaries() {
        Function<ListUserAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceUserSummaries() != null) {
                return response.instanceUserSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserAssociationsResponseFetcher
    implements AsyncPageFetcher<ListUserAssociationsResponse> {
        private ListUserAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserAssociationsResponse> nextPage(ListUserAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListUserAssociationsPublisher.this.client.listUserAssociations(ListUserAssociationsPublisher.this.firstRequest);
            }
            return ListUserAssociationsPublisher.this.client.listUserAssociations((ListUserAssociationsRequest)((Object)ListUserAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

