/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary;

public class ListProductSubscriptionsPublisher
implements SdkPublisher<ListProductSubscriptionsResponse> {
    private final LicenseManagerUserSubscriptionsAsyncClient client;
    private final ListProductSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProductSubscriptionsPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListProductSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProductSubscriptionsPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListProductSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProductSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProductSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProductUserSummary> productUserSummaries() {
        Function<ListProductSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.productUserSummaries() != null) {
                return response.productUserSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProductSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProductSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListProductSubscriptionsResponse> {
        private ListProductSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProductSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProductSubscriptionsResponse> nextPage(ListProductSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListProductSubscriptionsPublisher.this.client.listProductSubscriptions(ListProductSubscriptionsPublisher.this.firstRequest);
            }
            return ListProductSubscriptionsPublisher.this.client.listProductSubscriptions((ListProductSubscriptionsRequest)((Object)ListProductSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

